/* 
 * $Id$ 
 */

package csbase.logic.algorithms;

import java.io.File;
import java.io.Serializable;

import csbase.logic.FileInfo;
import csbase.logic.IPathFactory;

public class DocumentationPathFactory implements IPathFactory, Serializable {

  private AlgorithmVersionInfo version;

  public DocumentationPathFactory(AlgorithmVersionInfo version) {
    this.version = version;
  }

  @Override
  public String getPath(FileInfo fileInfo) {
    return version.getDocDirPath() + File.separator + fileInfo.getPath();
  }
}
