/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.ChoicePermission;
import csbase.logic.Permission;
import csbase.logic.User;
import csbase.logic.applicationservice.ApplicationRegistry;
import csbase.remote.ClientRemoteLocator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import tecgraf.javautils.core.lng.LNG;

public class ApplicationPermission
extends ChoicePermission {
    private static final String APPLICATIONS = "APPLICATIONS";
    private static final String ALL = "#####";

    public ApplicationPermission() {
    }

    public ApplicationPermission(String name, String description, Map<?, ?> attributes) {
        super(name, description, attributes);
    }

    @Override
    public Map<String, Object> getDomain() {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put(APPLICATIONS, true);
        return map;
    }

    @Override
    public Map<String, Object> getRange(String attribute) throws Exception {
        LinkedHashMap<String, Object> range = new LinkedHashMap<String, Object>();
        Hashtable<String, ApplicationRegistry> applicationRegistries = ClientRemoteLocator.applicationService.getApplicationRegistries();
        Set<String> appIds = applicationRegistries.keySet();
        range.put(LNG.get((String)(this.getClass().getName() + ".types.all")), ALL);
        for (String id : appIds) {
            ApplicationRegistry registry = applicationRegistries.get(id);
            if (!range.containsKey(registry.getApplicationName(LNG.getLocale()))) {
                range.put(registry.getApplicationName(LNG.getLocale()), id);
                continue;
            }
            String oldId = (String)range.remove(registry.getApplicationName(LNG.getLocale()));
            range.put(this.formatRangeKey(oldId, registry.getApplicationName(LNG.getLocale())), oldId);
            range.put(this.formatRangeKey(id, registry.getApplicationName(LNG.getLocale())), id);
        }
        return range;
    }

    private String formatRangeKey(String appId, String appName) {
        return appName + " (" + appId + ")";
    }

    public static boolean userHasPermission(User user, String appId) throws Exception {
        if (user.isAdmin()) {
            return true;
        }
        Vector<Object> permissionIds = user.getAllPermissionIds();
        HashSet permissions = new HashSet();
        for (Object object : permissionIds) {
            List applications;
            Permission p = Permission.getPermission(object);
            if (p == null || !(p instanceof ApplicationPermission) || permissions.contains(p) || !(applications = (List)((ApplicationPermission)p).getAttributes().get(APPLICATIONS)).contains(ALL) && !applications.contains(appId)) continue;
            return true;
        }
        return false;
    }
}

