/**
 * $Id: ProjectFilesDeletedEvent.java 179359 2017-03-13 19:58:16Z cviana $
 */

package csbase.logic;

/**
 * Representa o evento de remoo de um arquivo na rvore do projeto.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class ProjectFilesDeletedEvent extends ProjectEvent {
  /**
   * O caminho dos arquivos excludos.
   */
  private String[][] paths;
  /**
   * Os arquivos excludos.
   */
  private ClientProjectFile[] removedFiles;

  /**
   * Retorna os caminhos dos arquivos excludos como resultado do evento
   * ocorrido.
   * 
   * @return Os caminhos dos arquivos excludos.
   */
  public String[][] getPaths() {
    return paths;
  }

  /**
   * Define os arquivos excludos.
   * 
   * @param removedFiles os arquivos excludos.
   */
  public void setRemovedFiles(ClientProjectFile[] removedFiles) {
    this.removedFiles = removedFiles;
  }

  /**
   * Obtm os arquivos excludos.
   * 
   * @return os arquivos excludos.
   */
  public ClientProjectFile[] getRemovedFiles() {
    return this.removedFiles;
  }

  /**
   * Cria uma instncia de {@code ProjectEvent} para o evento de remoo de
   * um arquivo na rvore de um projeto.
   * 
   * @param projectId identificador do projeto.
   * @param paths O caminho do arquivo excludo.
   */
  public ProjectFilesDeletedEvent(Object projectId, String[][] paths) {
    event = FILES_DELETED;
    this.projectId = projectId;
    this.paths = paths;
  }
}
