/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import tecgraf.javautils.parsers.FiniteAutomaton;
import tecgraf.javautils.parsers.Parser;
import tecgraf.javautils.parsers.State;
import tecgraf.javautils.parsers.Token;
import tecgraf.javautils.parsers.actions.AppendAction;
import tecgraf.javautils.parsers.actions.DiscardAction;
import tecgraf.javautils.parsers.actions.GenerateTokenAction;
import tecgraf.javautils.parsers.actions.TransitionAction;
import tecgraf.javautils.parsers.exception.AutomatonException;
import tecgraf.javautils.parsers.iterators.CharSymbolIterator;
import tecgraf.javautils.parsers.iterators.SymbolIterator;
import tecgraf.javautils.parsers.symbols.CharSymbol;
import tecgraf.javautils.parsers.symbols.Symbol;

final class ListParameterParser
extends Parser {
    static final char START_LINE_CHAR = '{';
    static final char ELEMENT_SEPARATOR_CHAR = ',';
    static final char END_LINE_CHAR = '}';

    ListParameterParser() {
        super((FiniteAutomaton)new ListParameterFiniteAutomaton());
    }

    List<String> parseText(Reader reader) throws IOException, AutomatonException {
        int current;
        StringBuilder buffer = new StringBuilder();
        while ((current = reader.read()) != -1) {
            buffer.append((char)current);
        }
        String text = buffer.toString();
        return this.parseText(text);
    }

    List<String> parseText(String text) throws AutomatonException {
        List tokenList = this.parse((SymbolIterator)new CharSymbolIterator(text));
        return this.createStringList(tokenList);
    }

    private List<String> createStringList(List<Token> tokens) {
        ArrayList<String> stringList = new ArrayList<String>(tokens.size());
        for (Token token : tokens) {
            List symbolList = token.getSymbolList();
            Iterator symbolListIterator = symbolList.iterator();
            StringBuffer buffer = new StringBuffer();
            while (symbolListIterator.hasNext()) {
                CharSymbol symbol = (CharSymbol)symbolListIterator.next();
                Character object = symbol.getObject();
                buffer.append(object);
            }
            stringList.add(buffer.toString());
        }
        return stringList;
    }

    private static class ListParameterFiniteAutomaton
    extends FiniteAutomaton {
        private static final CharSymbol START_LINE_SYMBOL = new CharSymbol('{');
        private static final CharSymbol ELEMENT_SEPARATOR_SYMBOL = new CharSymbol(',');
        private static final CharSymbol END_LINE_SYMBOL = new CharSymbol('}');

        private ListParameterFiniteAutomaton() {
            super(new State(false));
            State startLineState = this.getInitialState();
            State elementState = new State(false);
            State endLineState = new State(true);
            startLineState.addTransition((Symbol)START_LINE_SYMBOL, (TransitionAction)DiscardAction.getInstance(), elementState);
            elementState.addTransition((Symbol)ELEMENT_SEPARATOR_SYMBOL, (TransitionAction)GenerateTokenAction.getInstance(), elementState);
            elementState.addTransition((Symbol)END_LINE_SYMBOL, (TransitionAction)DiscardAction.getInstance(), endLineState);
            elementState.setDefaultTransition((TransitionAction)AppendAction.getInstance(), elementState);
        }
    }
}

