/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers.triggers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.EnumerationParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.triggers.SetVisibleEnumerationItemTrigger;
import csbase.logic.algorithms.parameters.triggers.Trigger;
import csbase.logic.algorithms.parsers.XmlParser;
import csbase.logic.algorithms.parsers.triggers.AbstractSimpleTriggerFactory;

public abstract class SetVisibleEnumerationItemTriggerFactory
extends AbstractSimpleTriggerFactory {
    static final String ITEM_ATTRIBUTE = "item";
    private boolean isVisible;

    protected SetVisibleEnumerationItemTriggerFactory(String elementName, boolean isVisible) {
        super(elementName, true);
        this.isVisible = isVisible;
    }

    @Override
    protected final Trigger<?> doCreateTrigger(XmlParser parser, Condition condition, Parameter<?> parameter, SimpleAlgorithmConfigurator configurator) throws ParseException {
        if (!(parameter instanceof EnumerationParameter)) {
            throw new ParseException("O par\u00e2metro {0} n\u00e3o \u00e9 uma enumera\u00e7\u00e3o com sele\u00e7\u00e3o simples.", parameter.getName(), "item_de_enumeracao");
        }
        EnumerationParameter enumerationParameter = (EnumerationParameter)parameter;
        String itemId = parser.extractAttributeValue(ITEM_ATTRIBUTE);
        EnumerationItem item = enumerationParameter.getItem(itemId);
        if (item == null) {
            throw new ParseException("N\u00e3o existe um item chamado {1} na enumera\u00e7\u00e3o {0}.", parameter, itemId);
        }
        return new SetVisibleEnumerationItemTrigger(enumerationParameter, condition, itemId, this.isVisible);
    }
}

