/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.applicationservice;

import csbase.logic.applicationservice.ApplicationRegistry;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.Set;
import java.util.TreeSet;
import tecgraf.javautils.core.lng.LNG;

public class AppPropertyResourceBundle {
    private Locale locale;
    private AppPropertyResourceBundle parent;
    private PropertyResourceBundle bundle;
    private ApplicationRegistry appReg;

    public AppPropertyResourceBundle(InputStream stream, Locale locale, ApplicationRegistry appReg) throws IOException {
        this.bundle = new PropertyResourceBundle(stream);
        this.locale = locale;
        this.appReg = appReg;
    }

    public void setParent(AppPropertyResourceBundle parent) {
        this.parent = parent;
    }

    public boolean containsKey(String key) {
        if (this.bundle.containsKey(key)) {
            return true;
        }
        if (this.parent == null) {
            return false;
        }
        return this.parent.containsKey(key);
    }

    public String getString(String key) {
        LNG.TranslationListener callback = null;
        try {
            String text = this.bundle.getString(key);
            callback = this.appReg.getTranslationListener();
            if (LNG.getLocale() != null && callback != null && !AppPropertyResourceBundle.inTheSameIdiom(this.locale, LNG.getLocale())) {
                System.err.println("[APP] Chave " + key + " exibida como sendo " + text);
                return callback.keyNotFoundInDefaultLanguage(key, text);
            }
            return text;
        }
        catch (MissingResourceException ex1) {
            if (this.parent == null) {
                return this.missingKeyMsg(key, callback);
            }
            try {
                return this.parent.getString(key);
            }
            catch (MissingResourceException ex2) {
                return this.missingKeyMsg(key, callback);
            }
        }
    }

    private static boolean inTheSameIdiom(Locale locale, Locale other) {
        return locale.getCountry().equals(other.getCountry()) && locale.getLanguage().equals(other.getLanguage());
    }

    private String missingKeyMsg(String key, LNG.TranslationListener callback) {
        String defaultText = "<<" + key + ">>";
        if (callback != null) {
            return callback.keyNotFound(key, defaultText);
        }
        System.err.println("[APP] Chave n\u00e3o encontrada: " + key);
        return defaultText;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public Set<String> allKeys() {
        TreeSet<String> allKeys = new TreeSet<String>();
        if (this.bundle != null) {
            allKeys.addAll(this.bundle.keySet());
        }
        if (this.parent != null) {
            allKeys.addAll(this.parent.allKeys());
        }
        return allKeys;
    }
}

