/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.CommonProjectInfo;
import csbase.logic.ProjectPermissions;
import csbase.remote.RemoteEvent;
import java.util.Collections;
import java.util.Set;
import tecgraf.javautils.core.lng.LNG;

public final class SharedProjectEvent
extends RemoteEvent {
    private Set<Object> eventUsersId;
    private CommonProjectInfo projectInfo;
    private Set<Object> usersRO;
    private Set<Object> usersRW;
    private final ProjectPermissions.SharingType sharingType;

    public SharedProjectEvent(CommonProjectInfo projectInfo, ProjectPermissions.SharingType sharingType) {
        this(null, projectInfo, null, null, sharingType);
    }

    public SharedProjectEvent(Set<Object> eventUsersId, CommonProjectInfo projectInfo, Set<Object> usersRO, Set<Object> usersRW, ProjectPermissions.SharingType sharingType) {
        if (sharingType != ProjectPermissions.SharingType.PARTIAL && (eventUsersId != null || usersRO != null || usersRW != null)) {
            throw new IllegalArgumentException(LNG.get((String)"csbase.logic.NullUsersSet") + (Object)((Object)sharingType));
        }
        this.projectInfo = projectInfo;
        this.sharingType = sharingType;
        this.eventUsersId = eventUsersId == null ? null : Collections.unmodifiableSet(eventUsersId);
        this.usersRO = usersRO;
        this.usersRW = usersRW;
    }

    public final CommonProjectInfo getProjectInfo() {
        return this.projectInfo;
    }

    public Set<Object> getUsersRO() {
        return this.usersRO;
    }

    public Set<Object> getUsersRW() {
        return this.usersRW;
    }

    public boolean isPublic() {
        return this.sharingType == ProjectPermissions.SharingType.ALL_RO || this.sharingType == ProjectPermissions.SharingType.ALL_RW;
    }

    public boolean isReadOnly() {
        return this.sharingType == ProjectPermissions.SharingType.ALL_RO;
    }

    public boolean contains(Object userId) {
        if (this.isPublic()) {
            return true;
        }
        if (this.sharingType == ProjectPermissions.SharingType.PRIVATE) {
            return false;
        }
        return this.usersRO.contains(userId) || this.usersRW.contains(userId);
    }

    public Set<Object> getEventUsersId() {
        return this.eventUsersId;
    }

    public ProjectPermissions.SharingType getSharingType() {
        return this.sharingType;
    }
}

