/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.flows.configurator;

import csbase.logic.algorithms.flows.configurator.Input;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import tecgraf.javautils.core.lng.LNG;

public final class Output
implements Serializable {
    private Set<Input> inputs = new HashSet<Input>();
    private int nodeId;
    private String parameterName;
    private boolean isDir;

    public Output(int nodeId, String parameterName, boolean isDir) {
        this.setDir(isDir);
        this.setNodeId(nodeId);
        this.setParameterName(parameterName);
    }

    public boolean isDir() {
        return this.isDir;
    }

    private void setDir(boolean isDir) {
        this.isDir = isDir;
    }

    public boolean addInput(Input input) {
        if (input == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "input"));
        }
        return this.inputs.add(input);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        Output output = (Output)obj;
        if (output.getNodeId() != this.getNodeId()) {
            return false;
        }
        return output.getParameterName().equals(this.getParameterName());
    }

    public Collection<Input> getInputs() {
        return Collections.unmodifiableCollection(this.inputs);
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public String getParameterName() {
        return this.parameterName;
    }

    public int hashCode() {
        return this.getNodeId();
    }

    public boolean removeInput(int nodeId, String parameterName) {
        if (parameterName == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "parameterName"));
        }
        Iterator<Input> inputIterator = this.inputs.iterator();
        while (inputIterator.hasNext()) {
            Input input = inputIterator.next();
            if (input.getNodeId() != nodeId || !input.getParameterName().equals(parameterName)) continue;
            inputIterator.remove();
            return true;
        }
        return false;
    }

    private void setNodeId(int nodeId) {
        this.nodeId = nodeId;
    }

    private void setParameterName(String parameterName) {
        if (parameterName == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "parameterName"));
        }
        this.parameterName = parameterName;
    }
}

