/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.validators;

import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.validators.SimpleParameterValidator;
import csbase.logic.algorithms.validation.LocalizedMessage;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import csbase.logic.algorithms.validation.ValidationError;
import csbase.logic.algorithms.validation.ValidationMode;
import csbase.logic.algorithms.validation.ValidationSuccess;
import java.rmi.RemoteException;
import java.util.List;

public class ListParameterValidator<E>
extends SimpleParameterValidator<List<E>> {
    private SimpleParameterValidator<E> itemValidator;

    public ListParameterValidator(SimpleParameterValidator<E> itemValidator) {
        super(itemValidator.isOptional());
        this.itemValidator = itemValidator;
    }

    public SimpleParameterValidator<E> getItemValidator() {
        return this.itemValidator;
    }

    @Override
    public void setMode(ValidationMode mode) {
        this.itemValidator.setMode(mode);
        super.setMode(mode);
    }

    @Override
    public Validation validateValue(SimpleParameter<?> parameter, List<E> values, ValidationContext context) throws RemoteException {
        if (!parameter.isEnabled() || !parameter.isVisible()) {
            return new ValidationSuccess();
        }
        if (values == null || values.isEmpty()) {
            if (this.isOptional() || this.getMode().equals((Object)ValidationMode.ALLOW_EMPY_VALUES)) {
                return new ValidationSuccess();
            }
            LocalizedMessage message = new LocalizedMessage(ListParameterValidator.class, "empty_value", new Object[]{parameter.getLabel()});
            return new ValidationError(message);
        }
        for (int i = 0; i < values.size(); ++i) {
            E itemValue = values.get(i);
            Validation result = this.itemValidator.validateValue(parameter, itemValue, context);
            if (result.isWellSucceeded()) continue;
            return result;
        }
        return new ValidationSuccess();
    }
}

