/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers.columns;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.BooleanColumn;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.TableColumn;
import csbase.logic.algorithms.parsers.XmlParser;
import csbase.logic.algorithms.parsers.columns.AbstractTableColumnFactory;

public final class BooleanColumnFactory
extends AbstractTableColumnFactory {
    private static final String ELEMENT_NAME = "coluna_de_booleanos";

    public BooleanColumnFactory() {
        super(ELEMENT_NAME);
    }

    @Override
    public void setCellValue(XmlParser parser, String parameterName, TableColumn<?> column, int rowIndex, String valueAttributeName) throws ParseException {
        BooleanColumn booleanColumn = (BooleanColumn)column;
        boolean cellValue = parser.extractAttributeValueAsBoolean(valueAttributeName);
        booleanColumn.addDefaultValue(rowIndex, cellValue);
    }

    protected BooleanColumn createColumn(XmlParser parser, String parameterName, String label, String id, boolean isOptional, boolean isEditable, SimpleAlgorithmConfigurator configurator) throws ParseException {
        String falseCommand = parser.extractAttributeValue("falso", null);
        String trueCommand = parser.extractAttributeValue("verdadeiro", null);
        boolean defaultValue = parser.extractAttributeValueAsBoolean("padrao", false);
        parser.checkAttributes();
        parser.checkChildElements();
        return new BooleanColumn(id, label, defaultValue, isEditable, falseCommand, trueCommand);
    }
}

