package csbase.logic;

import java.io.Serializable;

public class ClientProjectFileInfo implements Serializable {
  private String type;
  private long size;
  private long modificationDate;
  private boolean isUnderConstruction;
  /** Indica se o arquivo est bloqueado. */
  private boolean isLocked;

  public String getType() {
    return type;
  }
  public long getSize() {
    return size;
  }
  public long getModificationDate() {
    return modificationDate;
  }
  public boolean isUnderConstruction() {
    return isUnderConstruction;
  }
  public void setType(String newType) {
    type = newType;
  }
  public void setSize(long newSize) {
    size = newSize;
  }
  public void setModificationDate(long newModificationDate) {
    modificationDate = newModificationDate;
  }
  public void setUnderConstruction(boolean newState) {
    isUnderConstruction = newState;
  }

  /**
   * Indica se o arquivo est bloqueado
   * @return true se o arquivo estiver bloqueado
   */
  public boolean isLocked() {
    return isLocked;
  }

  public ClientProjectFileInfo(String type, long size, long modificationDate,
    boolean isUnderConstruction, boolean isLocked) {
    this.type = type;
    this.size = size;
    this.modificationDate = modificationDate;
    this.isUnderConstruction = isUnderConstruction;
    this.isLocked = isLocked;
  }
}
