package csbase.logic;

/**
 * Classe responsvel pelas prioridades dos comandos na fila de prioridades.
 * As prioridades declaradas aqui devem seguir a ordem decrescente de 
 * importncia.  
 */
public enum Priority {
  /**
   * O comando no fica na fila do escalonador. Ele entra na fila, mas na primeira
   * passada do escalonador, se no houver nenhum SGA capaz de executar o
   * comando, ele  retirado da fila e uma notificao INIT_FAILURE  enviada.
   */
  ROOT,
  /**
   * O Comando ser escolhido antes de todos os comandos de prioridade MEDIUM ou
   * LOW.
   */
  HIGH,
  /**
   * O Comando ser escolhido antes de todos os comandos de prioridade LOW.
   */
  MEDIUM,
  /**
   * O Comando ser escolhido aps todos os comandos de prioridade HIGH e
   * MEDIUM.
   */
  LOW;
  
 /** PASSA A USAR A ordinal
  * Retorna o ndice da constante no array 'values', ou -1 se no encontrada.
  * @param constantToFind - a constante a ser procurada
  * /
  public static int getIndex(Enum constantToFind) {
   for(int i = 0; i < values().length; i++)
     if(values()[i] == constantToFind)
       return i;
   return -1;
  }
*/
  
  /**
   * Obtm a prioridade padro.
   * 
   * @return .
   */
  public static Priority getDefault() {
    return HIGH;
  }
}
