/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

public class ProgressData {
    private String description;
    private Double value;

    public ProgressData(Double value) {
        this(null, value);
    }

    public ProgressData(String description) {
        this(description, Double.NaN);
    }

    public ProgressData(String description, Double value) {
        if (value == null || value.isNaN() || value < 0.0 || value > 100.0) {
            this.value = Double.NaN;
            this.description = description;
        } else {
            this.value = value;
            this.description = description == null ? this.getFormattedValue() : description;
        }
    }

    public String getFormattedValue() {
        return String.format("%.0f%%", this.value);
    }

    public Double getValue() {
        return this.value;
    }

    public String getDescription() {
        return this.description;
    }
}

