/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.parameters.EnumerationItem;
import csbase.logic.algorithms.parameters.TableColumn;
import csbase.logic.algorithms.parameters.validators.EnumerationParameterValidator;
import csbase.logic.algorithms.parameters.validators.SimpleParameterValidator;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import tecgraf.javautils.core.lng.LNG;

public final class EnumerationColumn
extends TableColumn<EnumerationItem> {
    private List<EnumerationItem> items;

    public EnumerationColumn(String id, String label, EnumerationItem defaultItem, List<EnumerationItem> items, boolean mustSortItems) {
        super(id, label, defaultItem, false, true);
        if (mustSortItems) {
            Collections.sort(items);
        }
        this.setItems(items);
    }

    @Override
    public String getCommandValue(EnumerationItem itemValue, CommandLineContext context) {
        if (itemValue == null) {
            return null;
        }
        return itemValue.getCommandValue(context);
    }

    @Override
    public String getItemValueAsText(EnumerationItem itemValue) {
        return itemValue.getId();
    }

    @Override
    public EnumerationItem getItemValueFromText(String itemValue) throws ParseException {
        if (itemValue == null) {
            return null;
        }
        for (EnumerationItem item : this.items) {
            if (!itemValue.equals(item.getId())) continue;
            return item;
        }
        throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parameters.ItemNotFound"), itemValue);
    }

    public List<EnumerationItem> getItems() {
        return Collections.unmodifiableList(this.items);
    }

    @Override
    public Object getValueToExport(EnumerationItem itemValue) {
        if (itemValue == null) {
            return null;
        }
        return itemValue.getId();
    }

    @Override
    public EnumerationItem getValueToImport(Object importedValue) {
        String enumerationItemId = (String)importedValue;
        if (enumerationItemId == null) {
            return null;
        }
        for (EnumerationItem item : this.items) {
            if (!enumerationItemId.equals(item.getId())) continue;
            return item;
        }
        throw new IllegalArgumentException(String.format(LNG.get((String)"csbase.logic.algorithms.parameters.InvalidEnumColumnValue"), enumerationItemId, this.getLabel()));
    }

    @Override
    public SimpleParameterValidator<EnumerationItem> getValidator() {
        return new EnumerationParameterValidator(this.isOptional());
    }

    private void setItems(List<EnumerationItem> items) {
        if (items == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "items"));
        }
        if (items.isEmpty()) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.EmptyParameter"), "items"));
        }
        this.items = new ArrayList<EnumerationItem>(items);
    }
}

