package csbase.logic.sga.filter;

import csbase.logic.SGASet;

import java.util.LinkedList;
import java.util.List;

public class SGAFilter {
	private SGACriteria criteria;

	public SGAFilter (SGACriteria criteria)
	{
		this.criteria = criteria;
	}
	
	public List<SGASet> filter (List<SGASet> servers)
	{
		List<SGASet> filteredSGAs = new LinkedList<SGASet>();
		for (SGASet sga:servers)
			if (criteria.meetCriteria(sga))
				filteredSGAs.add(sga);
		return filteredSGAs;
	}
}
