/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.OperationFailureException;
import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parsers.XmlParser;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.List;

public interface ParameterFactory
extends Serializable {
    public Parameter<?> createParameter(XmlParser var1, String var2, ParameterGroup var3, SimpleAlgorithmConfigurator var4) throws ParseException;

    public List<Class<? extends Parameter>> getParameterTypes();

    public static ParameterFactory createParameterFactory(String factoryClassName) throws OperationFailureException {
        ParameterFactory factory;
        Constructor<?> factoryConstructor;
        Class<?> factoryClass;
        try {
            factoryClass = Class.forName(factoryClassName);
        }
        catch (ClassNotFoundException e) {
            throw new OperationFailureException("A classe {0} n\u00e3o foi encontrada.", factoryClassName);
        }
        if (!ParameterFactory.class.isAssignableFrom(factoryClass)) {
            throw new OperationFailureException("A classe {0} n\u00e3o implementa a interface necess\u00e1ria {1}.", factoryClassName, ParameterFactory.class.getName());
        }
        try {
            factoryConstructor = factoryClass.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new OperationFailureException("N\u00e3o existe um construtor vazio em {0}.", factoryClassName);
        }
        try {
            factory = (ParameterFactory)factoryConstructor.newInstance(new Object[0]);
        }
        catch (InstantiationException e) {
            throw new OperationFailureException(MessageFormat.format("N\u00e3o foi poss\u00edvel construir a f\u00e1brica {0}.", factoryClassName), e);
        }
        catch (IllegalAccessException e) {
            throw new OperationFailureException(MessageFormat.format("Construtor da f\u00e1brica {0} n\u00e3o aceita os par\u00e2metros usados.", factoryClassName), e);
        }
        catch (InvocationTargetException e) {
            throw new OperationFailureException(MessageFormat.format("Erro ao construir a f\u00e1brica de par\u00e2metros {0}.", factoryClassName), e.getTargetException());
        }
        return factory;
    }
}

