/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers.triggers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.FileParameter;
import csbase.logic.algorithms.parameters.OutputFileParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.triggers.ChangeFileTypeTrigger;
import csbase.logic.algorithms.parameters.triggers.Trigger;
import csbase.logic.algorithms.parsers.XmlParser;
import csbase.logic.algorithms.parsers.triggers.AbstractSimpleTriggerFactory;

public final class ChangeFileTypeTriggerFactory
extends AbstractSimpleTriggerFactory {
    private static final String NEW_FILE_TYPE_ATTRIBUTE = "novo_tipo";

    public ChangeFileTypeTriggerFactory() {
        super("trocar_tipo_de_arquivo", false);
    }

    @Override
    protected Trigger<?> doCreateTrigger(XmlParser parser, Condition condition, Parameter<?> parameter, SimpleAlgorithmConfigurator configurator) throws ParseException {
        if (!(parameter instanceof FileParameter)) {
            throw new ParseException("O par\u00e2metro {0} n\u00e3o \u00e9 de um tipo v\u00e1lido.\nTipos permitidos:\n{1};\n{2}.", parameter.getName(), "arquivo_de_entrada", "arquivo_de_saida");
        }
        String[] fileTypeList = parser.extractAttributeValueAsArray(NEW_FILE_TYPE_ATTRIBUTE, null);
        if (fileTypeList != null && fileTypeList.length > 1 && parameter instanceof OutputFileParameter) {
            throw new ParseException("O par\u00e2metro {0} n\u00e3o aceita mais de um tipo.\n", parameter.getName());
        }
        return new ChangeFileTypeTrigger((FileParameter)parameter, condition, fileTypeList);
    }
}

