/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.validation;

import csbase.logic.algorithms.validation.LocalizedMessage;
import java.util.ArrayList;
import java.util.List;

public class Validation {
    private boolean isWellSucceeded = true;
    private List<LocalizedMessage> messages;
    private List<Validation> children;

    public Validation() {
        this.isWellSucceeded = true;
        this.messages = null;
        this.children = new ArrayList<Validation>();
    }

    public Validation(Validation result) {
        this.isWellSucceeded = result.isWellSucceeded();
        this.children = result.getChildren();
        this.messages = result.getMessage();
    }

    public Validation(boolean isWellSuceeded, LocalizedMessage message) {
        this.isWellSucceeded = isWellSuceeded;
        this.children = null;
        this.messages = new ArrayList<LocalizedMessage>();
        if (message != null) {
            this.messages.add(message);
        }
    }

    public boolean isWellSucceeded() {
        return this.isWellSucceeded;
    }

    public List<LocalizedMessage> getMessage() {
        if (this.children != null) {
            ArrayList<LocalizedMessage> returnMessages = new ArrayList<LocalizedMessage>();
            for (Validation child : this.children) {
                returnMessages.addAll(child.getMessage());
            }
            return returnMessages;
        }
        return this.messages;
    }

    public List<Validation> getChildren() {
        return this.children;
    }

    public void addChild(Validation validation) {
        if (this.children == null) {
            throw new IllegalArgumentException("Not a group result");
        }
        this.children.add(validation);
        this.isWellSucceeded &= validation.isWellSucceeded();
    }
}

