/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.CapacityType;
import csbase.logic.MonitoringSet;
import csbase.logic.SGAInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Map;
import java.util.Set;
import java.util.Vector;

public class SGASet
implements MonitoringSet,
Comparable<SGASet> {
    private SGAInfo[] info = null;
    private String name = null;
    private String platform = null;
    private boolean isCluster;
    private boolean enabled;
    private boolean alive;
    private boolean hasDiskAccess;
    private boolean backoffExpired;
    private String jobsInfo;
    private boolean CSFSEnabled;
    private Map<String, String> properties;
    private long updateTimestamp;

    private String updatePlatformId() {
        StringBuilder allPlats = new StringBuilder();
        if (this.info != null) {
            Vector<String> plats = new Vector<String>();
            for (int i = 0; i < this.info.length; ++i) {
                String platformId = this.info[i].getPlatformId();
                if (plats.contains(platformId)) continue;
                plats.add(platformId);
            }
            Enumeration e = plats.elements();
            while (e.hasMoreElements()) {
                allPlats.append((String)e.nextElement());
                if (!e.hasMoreElements()) continue;
                allPlats.append('/');
            }
        }
        return allPlats.toString();
    }

    @Override
    public int compareTo(SGASet object) {
        return this.toString().compareToIgnoreCase(object.toString());
    }

    public SGAInfo getHost(String hostName) {
        int i;
        for (i = this.info.length - 1; i > 0 && !this.info[i].getHostName().equals(hostName); --i) {
        }
        return this.info[i];
    }

    public SGAInfo getInfo(int index) {
        return this.info[index];
    }

    public SGAInfo[] getAllInfo() {
        return this.info;
    }

    public String[] getAllNames() {
        Object[] names = new String[this.info.length];
        for (int i = 0; i < this.info.length; ++i) {
            names[i] = this.info[i].getHostName();
        }
        Arrays.sort(names);
        return names;
    }

    public long getCapacity(CapacityType capacityType) {
        return this.info[0].getCapacity(capacityType);
    }

    public int getNumNodes() {
        return this.info.length;
    }

    public int getNumProcessors() {
        return this.info[0].getNumProcessors();
    }

    public int getRAMMemoryInfoMb() {
        return this.info[0].getRAMMemoryInfoMb();
    }

    public int getSwapMemoryInfoMb() {
        return this.info[0].getSwapMemoryInfoMb();
    }

    public boolean getEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPlatformSupported(Collection<String> platformId) {
        for (int i = 0; i < this.info.length; ++i) {
            String nodePlatform = this.info[i].getPlatformId();
            if (!platformId.contains(nodePlatform)) continue;
            return true;
        }
        return false;
    }

    public String getPlatformId() {
        return this.platform;
    }

    public String getHostOfPlatform(Collection<String> plats) {
        for (int i = 0; i < this.info.length; ++i) {
            String platformId = this.info[i].getPlatformId();
            if (!plats.contains(platformId)) continue;
            return this.info[i].getHostName();
        }
        return null;
    }

    public double getCPULoad1() {
        return this.info[0].getCPULoad1();
    }

    public double getCPULoad5() {
        return this.info[0].getCPULoad5();
    }

    public double getCPULoad15() {
        return this.info[0].getCPULoad15();
    }

    public double getRAMFreeMemory() {
        return this.info[0].getRAMFreeMemory();
    }

    public double getRAMFreeMemoryMb() {
        double maxMem = this.info[0].getRAMFreeMemoryMb();
        int maxnode = this.info.length;
        for (int nnode = 1; nnode < maxnode; ++nnode) {
            if (!(this.info[nnode].getRAMFreeMemoryMb() > maxMem)) continue;
            maxMem = this.info[nnode].getRAMFreeMemoryMb();
        }
        return maxMem;
    }

    public double getSwapFreeMemory() {
        return this.info[0].getSwapFreeMemory();
    }

    public boolean hasRequirement(String requirement) {
        for (SGAInfo node : this.info) {
            if (node.hasRequirement(requirement)) continue;
            return false;
        }
        return true;
    }

    public boolean hasRequirements(Set<String> requirements) {
        for (String requirement : requirements) {
            for (SGAInfo node : this.info) {
                if (node.hasRequirement(requirement)) continue;
                return false;
            }
        }
        return true;
    }

    public Status getStatus() {
        if (this.getAlive()) {
            if (this.getEnabled()) {
                if (this.hasDiskAccess()) {
                    if (!this.backoffExpired) {
                        return Status.BACKOFF;
                    }
                    return Status.AVAILABLE;
                }
                return Status.DISKLESS;
            }
            return Status.RESERVED;
        }
        return Status.INACCESSIBLE;
    }

    public boolean mayExecuteCommand() {
        return this.getAlive() && this.getEnabled() && this.hasDiskAccess() && this.isBackoffExpired();
    }

    public boolean getAlive() {
        return this.alive;
    }

    public void setAlive(boolean alive) {
        this.alive = alive;
        if (alive) {
            return;
        }
        for (int i = 0; i < this.info.length; ++i) {
            this.info[i].setAlive(false);
        }
    }

    public boolean isCluster() {
        return this.isCluster;
    }

    public boolean hasDiskAccess() {
        return this.hasDiskAccess;
    }

    public String getJobsInfo() {
        return this.jobsInfo;
    }

    public boolean isCSFSEnabled() {
        return this.CSFSEnabled;
    }

    public String getProperty(String key) {
        return this.properties.get(key);
    }

    public String[] getPropertiesKeys() {
        String[] keys = new String[this.properties.size()];
        return this.properties.keySet().toArray(keys);
    }

    @Override
    public boolean equals(MonitoringSet o) {
        if (!(o instanceof SGASet)) {
            return false;
        }
        SGASet other = (SGASet)o;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (this.getAlive() != other.getAlive() || this.getEnabled() != other.getEnabled()) {
            return false;
        }
        if (this.hasDiskAccess() != other.hasDiskAccess()) {
            return false;
        }
        if (this.getCPULoad1() != other.getCPULoad1()) {
            return false;
        }
        if (this.getRAMMemoryInfoMb() != other.getRAMMemoryInfoMb()) {
            return false;
        }
        if (this.getSwapMemoryInfoMb() != other.getSwapMemoryInfoMb()) {
            return false;
        }
        return this.getPlatformId().equals(other.getPlatformId());
    }

    public int hashCode() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getName());
        buffer.append(Boolean.toString(this.getAlive()));
        buffer.append(Boolean.toString(this.getEnabled()));
        buffer.append(Double.toString(this.getCPULoad1()));
        buffer.append(Integer.toString(this.getRAMMemoryInfoMb()));
        buffer.append(Integer.toString(this.getSwapMemoryInfoMb()));
        buffer.append(this.getPlatformId());
        return buffer.toString().hashCode();
    }

    public SGAInfo getMainInfo() {
        return this.info[0];
    }

    @Override
    public String getKey() {
        return this.getName();
    }

    public String toString() {
        return this.getName();
    }

    public boolean isBackoffExpired() {
        return this.backoffExpired;
    }

    public long getUpdateTimestamp() {
        return this.updateTimestamp;
    }

    public SGASet(SGAInfo[] info, String name, boolean enabled, boolean alive, boolean hasDiskAccess, boolean backoffExpired, String jobsInfo, boolean CSFSEnabled, Map<String, String> properties, long updateTimestamp) {
        this.info = info;
        this.name = name;
        this.isCluster = info.length > 1;
        this.enabled = enabled;
        this.setAlive(alive);
        this.hasDiskAccess = hasDiskAccess;
        this.backoffExpired = backoffExpired;
        this.platform = this.updatePlatformId();
        this.jobsInfo = jobsInfo;
        this.CSFSEnabled = CSFSEnabled;
        this.properties = properties;
        this.updateTimestamp = updateTimestamp;
    }

    public static enum Status {
        AVAILABLE,
        DISKLESS,
        RESERVED,
        INACCESSIBLE,
        BACKOFF;


        public static int getIndex(Enum<Status> constantToFind) {
            for (int i = 0; i < Status.values().length; ++i) {
                if (Status.values()[i] != constantToFind) continue;
                return i;
            }
            return -1;
        }
    }
}

