/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parsers.StringToEnumConverter;
import tecgraf.javautils.core.lng.LNG;

public enum ExecutionLocation {
    BINARY_DIR,
    PERSISTENCY_DIR,
    SANDBOX;


    public static class ExecutionLocationConverter
    implements StringToEnumConverter<ExecutionLocation> {
        public String[] getPossibleMatches(ExecutionLocation value) {
            switch (value) {
                case BINARY_DIR: {
                    return new String[]{"BIN", "BIN_DIR", "BINARY_DIR"};
                }
                case PERSISTENCY_DIR: {
                    return new String[]{"CMD", "CMD_DIR", "PERSISTENCY_DIR"};
                }
                case SANDBOX: {
                    return new String[]{"SANDBOX", "SANDBOX_DIR"};
                }
            }
            return new String[0];
        }

        @Override
        public ExecutionLocation valueOf(String string) throws ParseException {
            if (string != null) {
                String upperCaseString = string.toUpperCase();
                for (ExecutionLocation location : ExecutionLocation.values()) {
                    String[] possibleMatches;
                    for (String possibleMatch : possibleMatches = this.getPossibleMatches(location)) {
                        if (!possibleMatch.toUpperCase().equals(upperCaseString)) continue;
                        return location;
                    }
                }
            }
            throw new ParseException(String.format(LNG.get((String)"csbase.logic.algorithms.StringNotMappedInEnum"), string, ExecutionLocation.class.getName()));
        }
    }
}

