/*
 * $Id$
 */
package csbase.logic;

/**
 * Notificao sobre a atualizao de um arquivo.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class FileUpdateNotification extends Notification {
  /**
   * Representa o resultado de uma atualizao.
   * 
   * @author Tecgraf/PUC-Rio
   */
  public enum Result {
    SUCCESS,
    UNEXPECTED_ERROR,
    SOURCE_NOT_FOUND,
    NO_PERMISSION,
    TEMPORARILY_UNAVAILABLE,
    DISABLED;
  }

  /**
   * O caminho do arquivo que est sendo atualizado.
   */
  private String filePath;
  /**
   * O resultado da atualizao.
   */
  private Result result;

  /**
   * Cria uma notificao sobre a atualizao de um arquivo.
   * 
   * @param sender Quem est enviando a notificao (no pode ser {@code null}).
   * @param filePath O caminho do arquivo que est sendo atualizado.
   * @param result O resultado da atualizao.
   */
  public FileUpdateNotification(String sender, String filePath,
    Result result) {
    super(sender);
    this.filePath = filePath;
    this.result = result;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean isVolatile() {
    return true;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    return "Notificao de atualizao do arquivo " + this.filePath;
  }

  /**
   * Obtm o caminho do arquivo atualizado.
   * 
   * @return O caminho do arquivo atualizado.
   */
  public String getFilePath() {
    return this.filePath;
  }

  /**
   * Obtm o resultado da atualizao.
   * 
   * @return O resultado da atualizao.
   */
  public Result getResult() {
    return this.result;
  }
}
