/*
 * SGANotificationData.java
 * $Author: pasti $
 * $Revision: 127396 $ - $Date: 2012-03-20 14:32:21 -0300 (Tue, 20 Mar 2012) $
 */
package csbase.logic;

/**
 * Classe que modela uma notificao de start-up/shutdownr/init do SGA
 * @author Andr Luiz Clinio
 */
public class SGANotification extends Notification {

  /** Flag de start-up */
  public static final int SGA_START_UP = 0;

  /** Flag de shutdown */
  public static final int SGA_SHUTDOWN = 1;

  /** Flag de reincio */
  public static final int SGA_REINIT = 2;
  
  /** Flag de atualizao */
  public static final int SGA_UPDATE = 3;  
  
  /** Strings de auditagem dos flags de notificao */
  private final String[] strFlag = { 
    "START-UP", "SHUTDOWN", "REINIT", "UPDATE"
  };

  /** Atributo de SGA novo detectado */
  private SGASet info;

  /** Atributo de estado */
  private int flag;

  /**
   * Definio da volatilidade da notificao.
   * @return flag indicativo.
   */
  public boolean isVolatile() {
    return true;
  }

  /**
   * Consulta ao flag de evento do SGA
   *
   * @return o cdigo do evento.
   */
  public int getFlag() {
    return flag;
  }

  /**
   * Consulta ao nome do SGA
   *
   * @return uma string com o nome.
   */
  public SGASet getMainInfo() {
    return info;
  }

  /**
   * String para auditagem.
   *
   * @return uma string
   */
  public String toString() {
    return "SGA/NOTIFICATION (cod." + flag + " / " + strFlag[flag] + ") " +
    " - " + getMainInfo().getName() + " (" + getMainInfo().getPlatformId() +
    ")";
  }

  /**
   * Constri o evento de notificao de SGA.
   * 
   * @param sender Quem est enviando a notificao (no pode ser {@code null}).
   * @param flag estado on/off.
   * @param info .
   */
  public SGANotification(String sender, int flag, SGASet info) {
    super(sender);
    this.flag = flag;
    this.info = info;
    setDisplay(flag != SGA_UPDATE);
  }
}
