package csbase.logic.algorithms.flows.configurator;

import java.io.Serializable;
import java.text.MessageFormat;

import tecgraf.javautils.core.lng.LNG;

public final class Input implements Serializable {

  private int nodeId;
  private String parameterName;

  public Input(int nodeId, String parameterName) {
    setNodeId(nodeId);
    setParameterName(parameterName);
  }

  @Override
  public boolean equals(Object obj) {
    if (obj == null) {
      return false;
    }
    if (!getClass().equals(obj.getClass())) {
      return false;
    }
    Input input = (Input) obj;
    if (input.getNodeId() != getNodeId()) {
      return false;
    }
    if (!input.getParameterName().equals(getParameterName())) {
      return false;
    }
    return true;
  }

  public int getNodeId() {
    return this.nodeId;
  }

  public String getParameterName() {
    return this.parameterName;
  }

  @Override
  public int hashCode() {
    return getNodeId();
  }

  private void setNodeId(int nodeId) {
    this.nodeId = nodeId;
  }

  private void setParameterName(String parameterName) {
    if (parameterName == null) {
      throw new IllegalArgumentException(MessageFormat.format(LNG.get(
    		  "csbase.logic.algorithms.nullParameter"),
    		  "parameterName"));
    }
    this.parameterName = parameterName;
  }
}
