package csbase.logic.algorithms.parameters;

public abstract class AbstractEnumerationItem implements EnumerationItem {

  /**
   * Indica se um item de enumerao est visvel ({@code true}) ou oculto (
   * {@code false}).
   */
  private boolean isVisible;

  protected AbstractEnumerationItem() {
    setVisible(true);
  }

  /**
   * A ordem natural de um item de enumerao  a ordem crescente dos rtulos.
   * 
   * {@inheritDoc}
   */
  @Override
  public final int compareTo(EnumerationItem item) {
    return getLabel().compareTo(item.getLabel());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public final boolean equals(Object o) {
    if (o == null) {
      return false;
    }
    if (!getClass().equals(o.getClass())) {
      return false;
    }
    EnumerationItem item = (EnumerationItem) o;
    return getId().equals(item.getId());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public final int hashCode() {
    return getId().hashCode();
  }

  /**
   * A representao com uma {@link java.lang.String} do item  o seu rtulo.
   * 
   * {@inheritDoc}
   */
  @Override
  public final String toString() {
    return getLabel();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public final boolean isVisible() {
    return this.isVisible;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public final boolean setVisible(boolean isVisible) {
    if (this.isVisible == isVisible) {
      return false;
    }
    this.isVisible = isVisible;
    return true;
  }
}
