/*
 * $Id:$
 */

package csbase.logic.algorithms.parameters.conditions;

import java.text.MessageFormat;

import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import tecgraf.javautils.core.lng.LNG;

/**
 * Condio NOT
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class NotOperatorCondition implements Condition {
  /**
   * A condio negada
   */
  private final Condition condition;

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean equals(final Object obj) {
    if (obj == null) {
      return false;
    }
    if (!obj.getClass().equals(getClass())) {
      return false;
    }
    final NotOperatorCondition notOperationCondition =
      (NotOperatorCondition) obj;
    return notOperationCondition.condition.equals(this.condition);
  }

  /**
   * {@inheritDoc}
   * 
   * Retorna o NOT da condio negada.
   */
  @Override
  public boolean evaluate(final SimpleAlgorithmConfigurator configurator) {
    return !this.condition.evaluate(configurator);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public int hashCode() {
    return this.condition.hashCode();
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public String toString() {
    String toString = "Classe = " + getClass().getName() + "\n";
    toString += "Condio interna = " + this.condition + "\n";
    return toString;
  }

  /**
   * Construtor
   * 
   * @param condition a condio negada.
   */
  public NotOperatorCondition(final Condition condition) {
    if (condition == null) {
      throw new IllegalArgumentException(
          MessageFormat.format(LNG.get(
              	"csbase.logic.algorithms.nullParameter"),
            	"condition"));
    }
    this.condition = condition;
  }
}
