/*
 * $Author:$ $Date:$ $Release:$
 */
package csbase.logic.algorithms.parameters.triggers;

import csbase.logic.algorithms.parameters.TextParameter;
import csbase.logic.algorithms.parameters.conditions.Condition;

/**
 * Gatilho Permitir Editar Parmetro: Torna um {@link TextParameter parmetro}
 * editvel quando a {@link Condition condio} associada for aceita.
 * 
 * @author lmoreira
 */
public final class AllowEditParameterTrigger extends Trigger<TextParameter> {
  /**
   * Cria o gatilho.
   * 
   * @param parameter O parmetro (No aceita {@code null}).
   * @param condition A condio (No aceita {@code null}).
   */
  public AllowEditParameterTrigger(TextParameter parameter, Condition condition) {
    super(parameter, condition);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void doAction() {
    getParameter().setEditable(true);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected void undoAction() {
    getParameter().setEditable(false);
  }
}
