package csbase.logic.algorithms.parsers;

import java.util.Collections;
import java.util.List;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.OutputFileParameter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.ParameterGroup;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;

/**
 * <p>
 * Analisador de {@link OutputFileParameter#createLogFile(String) arquivo de
 * log}.
 * </p>
 * 
 * <p>
 * Este parser l os atributos de parmetros do tipo "arquivo de log". O
 * elemento corrente do {@link XmlParser analisador de XML} precisa ser um
 * elemento que representa um arquivo de log.
 * </p>
 */
public class LogFileParameterFactory extends ParameterParser implements
  ParameterFactory {

  /**
   * {@inheritDoc}
   */
  @Override
  public Parameter<?> createParameter(XmlParser parser,
    String defaultCommandLinePattern, ParameterGroup group,
    SimpleAlgorithmConfigurator configurator) throws ParseException {
    String commandLinePattern = loadCommandLinePattern(parser,
      defaultCommandLinePattern);
    OutputFileParameter parameter = OutputFileParameter.createLogFile(
      commandLinePattern);
    return parameter;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public List<Class<? extends Parameter>> getParameterTypes() {
    return Collections.singletonList(OutputFileParameter.class);
  }

}
