package csbase.logic.algorithms.serializer.exception;

import csbase.logic.algorithms.AlgorithmVersionId;

/**
 * Exceco lancada quando um parmetro serializado no consta no modelo do
 * configurador. Isso pode indicar que o dado serializado  invlido ou que o
 * configurador serialiado  de uma verso diferente do configurador atual.
 * 
 * @author Tegraf / PUC-Rio
 */
public class AlgorithmConfigurationSerializerParameterNotFoundException extends
  AlgorithmConfigurationSerializerException {

  private String algorithmName;
  private AlgorithmVersionId algorithmVersionId;
  private String paramName;

  /**
   * @param cause erro/exceo que gerou esta.
   * @param algorithmName o nome do algoritmo cujo parmetro no foi encontrado
   *        durante a (des)serializao.
   * @param algorithmVersionId o identificador da verso do algoritmo cujo
   *        parmetro no foi encontrado durante a (des)serializao.
   * @param paramName o nome do parmetro que no foi encontrado no
   *        configurador.
   */
  public AlgorithmConfigurationSerializerParameterNotFoundException(
    final Throwable cause, final String algorithmName,
    final AlgorithmVersionId algorithmVersionId, final String paramName) {

    super(cause);
    this.algorithmName = algorithmName;
    this.algorithmVersionId = algorithmVersionId;
    this.paramName = paramName;
  }

  /**
   * Obtm o nome do algoritmo cujo parmetro no foi encontrado durante a
   * (des)serializao.
   * 
   * @return o nome do algoritmo.
   */
  public String getAlgorithmName() {
    return algorithmName;
  }

  /**
   * Obtm o identificador da verso do algoritmo cujo parmetro no foi
   * encontrado durante a (des)serializao.
   * 
   * @return o identificador da verso do algoritmo.
   */
  public AlgorithmVersionId getAlgorithmVersionId() {
    return algorithmVersionId;
  }

  /**
   * Obtm o nome do parmetro que no foi encontrado no configurador.
   * 
   * @return o nome do parmetro que no foi encontrado no configurador.
   */
  public String getParameterName() {
    return paramName;
  }
}
