package csbase.logic.projectservice;

import csbase.logic.ProjectFileInfo;

import java.util.Arrays;

/**
 * Template para filtrar tipos de arquivo a partir do diretrio-base.
 */
public class FileTypeTemplate extends DefaultProjectTemplate {

  /**
   * Construtor
   *
   * @param baseDir diretrio-base.
   * @param params parmetros para configurao do template.
   */
  public FileTypeTemplate(ProjectFileInfo baseDir, String... params) {
    super(baseDir, params);
  }

  /**
   * {@inheritDoc}
   */
  @Override
  public boolean canCreate(ProjectFileInfo parentDir, String name, String type) {
    if (!super.canCreate(parentDir, name, type)) {
      return false;
    }

    final ProjectFileInfo baseDir = getBaseDir();
    final String[] baseDirPath = baseDir.getPath();
    final String[] parentPath = parentDir.getPath();
    if (Arrays.equals(baseDirPath, parentPath) || isAncestor(baseDirPath, parentPath)) {
      return checkCondition(type);
    }
    return true;
  }

  @Override
  public boolean canChangeType(ProjectFileInfo file, String newType) {
    if (!super.canChangeType(file, newType)) {
      return false;
    }
    final ProjectFileInfo baseDir = getBaseDir();
    final String[] baseDirPath = baseDir.getPath();
    final String[] filePath = file.getPath();
    if (Arrays.equals(baseDirPath, filePath) || isAncestor(baseDirPath, filePath)) {
      return checkCondition(newType);
    }
    return true;
  }

  /**
   * Retorna indicativo de possibilidade de criao de arquivo.
   *
   * @param type tipo do arquivo criado dentro do diretrio
   * @return indicativo
   */
  private boolean checkCondition(String type) {
    String[] allowedTypes = getParameters();
    for (String allowedType : allowedTypes) {
      if (type.equalsIgnoreCase(allowedType)) {
        return true;
      }
    }
    return false;
  }


}
