package csbase.logic.sga.filter;

import csbase.logic.SGASet;

import java.util.List;

public class SGACriteriaAnd implements SGACriteria {

	private List<SGACriteria> criterias;

	public SGACriteriaAnd(List<SGACriteria> criterias)
	{
		this.criterias = criterias;
	}
	
	@Override
	public boolean meetCriteria(SGASet server) {
		for (SGACriteria crit: criterias)
		{
			if (!crit.meetCriteria(server))
				return false;
		}
		return true;
	}
}
