/**
 * $Id$
 */
package csbase.remote;

import java.io.Serializable;

/**
 * Representa um evento a ser notificado a um observador remoto. Carrega a
 * informao do momento de sua criao.
 * 
 * @author Tecgraf
 */
public class RemoteEvent implements Serializable {
  /**
   * Registra o momento de criao do evento.
   */
  private long creationDate;

  /**
   * Informa o momento em que essa notificao foi criada.
   * 
   * @return Tempo, como informado por System.currentTimeMillis, do momento de
   *         criao dessa mensagem.
   */
  public long getCreationDate() {
    return this.creationDate;
  }

  /**
   * Construtor de um evento remoto.
   */
  public RemoteEvent() {
    this.creationDate = System.currentTimeMillis();
  }
}
