/*
 * Detalhes da ltima alterao:
 *
 * $Author: taciana $
 * $Date: 2008-06-06 16:24:00 -0300 (Fri, 06 Jun 2008) $
 * $Revision: 76954 $
 */
package csbase.exception;

import java.text.MessageFormat;

/**
 * A classe <code>CSBaseRuntimeException</code> representa uma exceo do
 * tipo "unchecked". A descrio desse tipo de falha, quando houver, deve ser
 * adequada para para exibio ao usurio (incluindo internacionalizao). 
 * utilizado, tipicamente, para a comunicao de erros na execuo de um
 * servio remoto (ou seja, para a comunicao de erros entre servidor e
 * cliente). So comunicados por esse tipo de exceo erros como: -
 * indisponibilidade de um servio remoto - falha na execuo de um pedido de
 * servio (quando nenhum resultado pde ser obtido, tipicamente falhas de
 * I/O, SQL, bugs) - falta de permisso para a execuo de um servio - "bugs"
 * na implementao de um servio
 */
public abstract class CSBaseRuntimeException extends RuntimeException {

  /**
   * Constri uma exceo sem descrio nem causa associadas.
   */
  protected CSBaseRuntimeException() {
    super();
  }

  /**
   * Constri uma exceo contendo a descrio do erro correspondente.
   *
   * @param clientMessage a descrio do erro
   */
  protected CSBaseRuntimeException(String clientMessage) {
    super(clientMessage);
  }

  /**
   * Constri uma exceo contendo a descrio do erro correspondente.
   *
   * @param clientMessage a descrio do erro
   * @param detailMessage mensagem internacionalizada para ser mostrada no
   * cliente
   */
  protected CSBaseRuntimeException(String clientMessage, String detailMessage) {
    super(clientMessage);
  }

/**
   * Constri uma exceo contendo a causa/exceo original.
   *
   * @param exception a exceo original
   */
  protected CSBaseRuntimeException(Throwable exception) {
    super(null, exception);
  }

/**
   * Constri uma exceo contendo a descrio do erro e a causa/exceo
   * original.
   *
   * @param clientMessage a descrio do erro
   * @param exception a exceo original
   */
  protected CSBaseRuntimeException(String clientMessage, Throwable exception) {
    super(clientMessage, exception);
  }

  /**
   * Constri uma exceo contendo a descrio do erro correspondente.
   *
   * @param pattern um padro com a descrio do erro
   * @param arguments os argumentos que sero formatados na descrio do erro
   *
   * @see MessageFormat
   */
  protected CSBaseRuntimeException(String pattern, Object... arguments) {
    super(MessageFormat.format(pattern, arguments));
  }

}
