/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.algorithms.ExpressionFunctionExecutionException;
import csbase.logic.algorithms.parameters.ExpressionFunction;
import csbase.logic.algorithms.parameters.ListParameter;
import csbase.logic.algorithms.parameters.SimpleAlgorithmConfigurator;
import csbase.logic.algorithms.parameters.SimpleParameter;
import java.text.MessageFormat;
import java.util.List;
import tecgraf.javautils.core.lng.LNG;

public abstract class ListExpressionFunction
extends ExpressionFunction {
    public ListExpressionFunction(String name, Class<?> ... parameterTypes) {
        super(name, ListExpressionFunction.createParameterTypes(parameterTypes));
    }

    protected abstract Object doOperation(List<?> var1, Object ... var2) throws ExpressionFunctionExecutionException;

    @Override
    protected final Object doOperation(SimpleAlgorithmConfigurator configurator, Object ... parameters) throws ExpressionFunctionExecutionException {
        if (configurator == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "configurator"));
        }
        if (parameters == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "parameters"));
        }
        if (parameters.length == 0) {
            throw new ExpressionFunctionExecutionException(LNG.get((String)"csbase.logic.algorithms.parameters.MissingListName"), this);
        }
        if (!(parameters[0] instanceof String)) {
            throw new ExpressionFunctionExecutionException(LNG.get((String)"csbase.logic.algorithms.parameters.InvalidListParameter"), this, parameters[0]);
        }
        String parameterName = (String)parameters[0];
        SimpleParameter<?> parameter = configurator.getSimpleParameter(parameterName);
        if (parameter == null) {
            throw new ExpressionFunctionExecutionException(LNG.get((String)"csbase.logic.algorithms.parameters.ListNotFoundInConfigurator"), parameterName, configurator, this);
        }
        if (!(parameter instanceof ListParameter)) {
            throw new ExpressionFunctionExecutionException(LNG.get((String)"csbase.logic.algorithms.parameters.InvalidListConfigurator"), parameterName, configurator, this);
        }
        ListParameter listParameter = (ListParameter)parameter;
        Object[] newParameters = new Object[parameters.length - 1];
        for (int i = 0; i < newParameters.length; ++i) {
            newParameters[i] = parameters[i + 1];
        }
        List values = (List)listParameter.getValue();
        return this.doOperation(values, newParameters);
    }

    private static Class<?>[] createParameterTypes(Class<?>[] parameterTypes) {
        if (parameterTypes == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "parameterTypes"));
        }
        Class[] newParameterTypes = new Class[parameterTypes.length + 1];
        newParameterTypes[0] = String.class;
        for (int i = 1; i < newParameterTypes.length; ++i) {
            newParameterTypes[i] = parameterTypes[i - 1];
        }
        return newParameterTypes;
    }
}

