/**
 * $Id: CommandInfoCache.java 177953 2016-12-01 21:11:32Z fpina $
 */
package csbase.logic;

import java.util.Hashtable;
import java.util.Map;

/**
 * Garante que exista somente uma instncia de um objeto da classe CommandInfo
 * quando esta for deserializada.
 *
 * WA para ao carregar as filas do Scheduler e dos SGAs, atravs dos arquivos
 * de persistncias durante a recuperao do servidor, as referncias para
 * objetos da classe CommandInfo que representam um mesmo comando sejam
 * compartilhadas.
 *
 * @author Tecgraf/PUC-Rio
 */
public class CommandInfoCache {
  private static CommandInfoCache instance;
  private Map<String, CommandInfo> cache;
  private static boolean isEnable = false;

  private CommandInfoCache() {
    cache = new Hashtable<>();
  }

  public static CommandInfoCache getInstance() {
    if (instance == null) {
      instance = new CommandInfoCache();
    }

    return instance;
  }

  public static void enable() {
    isEnable = true;
  }

  public synchronized CommandInfo getCommandInfo(CommandInfo info) {
    if (!isEnable) {
      return info;
    }
    if (!cache.containsKey(info.getId())) {
      cache.put(info.getId(), info);
    } else {
      if (!info.getStatus().equals(CommandStatus.SCHEDULED)) {
        cache.get(info.getId()).setStatus(info.getStatus());
      }
    }
    return cache.get(info.getId());
  }
}
