/*
 * $Id:$
 */

package csbase.exception.algorithms;

import csbase.exception.CSBaseException;

/**
 * Exceo de expresso (funo usada internamente) com falha de execuo.
 * 
 * @author Tecgraf/PUC-Rio
 */
public final class ExpressionFunctionExecutionException extends CSBaseException {

  /**
   * Construtor
   * 
   * @param exception exceo
   */
  public ExpressionFunctionExecutionException(Throwable exception) {
    super(exception);
  }

  /**
   * Construtor
   * 
   * @param pattern padro
   * @param arguments argumentos.
   */
  public ExpressionFunctionExecutionException(String pattern,
    Object... arguments) {
    super(pattern, arguments);
  }

  /**
   * Construtor
   * 
   * @param pattern padro
   * @param arguments argumentos.
   * @param exception exceo.
   */
  public ExpressionFunctionExecutionException(String pattern,
    Object[] arguments, Throwable exception) {
    super(pattern, arguments, exception);
  }

  /**
   * Construtor
   * 
   * @param message mensagem.
   * @param exception exceo.
   */
  public ExpressionFunctionExecutionException(String message,
    Throwable exception) {
    super(message, exception);
  }

  /**
   * Construtor
   * 
   * @param message mensagem.
   */
  public ExpressionFunctionExecutionException(String message) {
    super(message);
  }

  /**
   * Construtor
   * 
   * @param exception exceo
   * @param pattern padro
   * @param arguments argumentos.
   */
  public ExpressionFunctionExecutionException(Throwable exception,
    String pattern, Object... arguments) {
    super(exception, pattern, arguments);
  }
}
