/**
 * $Id: DirRefreshedEvent.java 146059 2013-10-22 18:32:34Z fpina $
 */

package csbase.logic;

/**
 * Representa o evento de atualizao de um diretrio na rvore de projetos,
 * sincronizando-o com o seu equivalente no servidor.
 * 
 * @author Tecgraf/PUC-Rio
 */
public class DirRefreshedEvent extends ProjectEvent {
  /** Caminho para o diretrio sendo atualizado. */
  private String[] path;
  /** Referncia para o diretrio sendo atualizado. */
  private ClientProjectFile dir;

  /**
   * Obtm o caminho para o diretrio sendo atualizado.
   * 
   * @return caminho para o diretrio sendo atualizado.
   */
  public String[] getPath() {
    return path;
  }

  /**
   * Obtm a referncia para o diretrio sendo atualizado.
   * 
   * @return referncia para o diretrio sendo atualizado.
   */
  public ClientProjectFile getDir() {
    return dir;
  }

  /**
   * Cria o evento.
   * 
   * @param projectId o identificador do projeto sendo atualizado.
   * @param path caminho para o diretrio sendo atualizado.
   * @param dir referncia para o diretrio sendo atualizado.
   */
  DirRefreshedEvent(Object projectId, String[] path, ClientProjectFile dir) {
    event = DIR_REFRESHED;
    this.projectId = projectId;
    this.path = path;
    this.dir = dir;
  }
}