/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import tecgraf.javautils.core.lng.LNG;

public final class ServerURI
implements Serializable,
Comparable<ServerURI> {
    public static String CSBASE_SCHEME = "csbase";
    protected URI uri;

    private ServerURI(String str) {
        try {
            if (str == null) {
                throw new IllegalArgumentException("str == null");
            }
            this.uri = new URI(str);
            this.uri = this.uri.normalize();
            if (this.uri.getScheme() == null || !this.uri.getScheme().equals(CSBASE_SCHEME)) {
                throw new IllegalArgumentException(str + LNG.get((String)"csbase.logic.InvalidCSBaseURI"));
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(str + LNG.get((String)"csbase.logic.InvalidCSBaseURI"));
        }
    }

    public String getHostAndPort() {
        return this.getHost() + ":" + this.getPort();
    }

    public int getPort() {
        return this.uri.getPort() != -1 ? this.uri.getPort() : 1099;
    }

    public String getHost() {
        return this.uri.getHost();
    }

    public String getParams() {
        return this.uri.getQuery();
    }

    public Map<String, String> getParamsMap() {
        HashMap<String, String> params = null;
        if (this.getParams() != null) {
            params = new HashMap<String, String>();
            StringTokenizer st = new StringTokenizer(this.getParams(), "&");
            while (st.hasMoreTokens()) {
                String tk = st.nextToken();
                String[] p = tk.split("=");
                if (p.length != 2) continue;
                params.put(tk.split("=")[0], tk.split("=")[1]);
            }
        }
        if (params != null) {
            return Collections.unmodifiableMap(params);
        }
        return null;
    }

    public ServerURI appendParams(Map<String, String> params) {
        if (params == null) {
            throw new IllegalArgumentException("params == null");
        }
        if (params.size() != 0) {
            String strURI = CSBASE_SCHEME + "://" + this.getHostAndPort();
            Map<String, String> mergedParams = null;
            if (this.getParamsMap() != null) {
                mergedParams = new HashMap<String, String>(this.getParamsMap());
            }
            if (mergedParams == null) {
                mergedParams = params;
            } else {
                mergedParams.putAll(params);
            }
            strURI = strURI + '?';
            int c = mergedParams.size();
            for (Map.Entry<String, String> entry : mergedParams.entrySet()) {
                if (--c > 0) {
                    strURI = strURI + entry.getKey() + '=' + entry.getValue() + '&';
                    continue;
                }
                strURI = strURI + entry.getKey() + '=' + entry.getValue();
            }
            return new ServerURI(strURI);
        }
        return this;
    }

    public String toString() {
        return this.uri.toString();
    }

    public int hashCode() {
        Map<String, String> p = this.getParamsMap();
        if (p == null) {
            return this.getHostAndPort().hashCode();
        }
        long keyHash = 0L;
        long valueHash = 0L;
        for (String string : p.keySet()) {
            keyHash += (long)Math.abs(string.hashCode());
        }
        for (Serializable serializable : p.values()) {
            valueHash += (long)Math.abs(serializable.hashCode());
        }
        return this.getHostAndPort().hashCode() + (int)(keyHash * valueHash);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!obj.getClass().equals(this.getClass())) {
            return false;
        }
        ServerURI sURI = (ServerURI)obj;
        if (!this.getHostAndPort().equals(sURI.getHostAndPort())) {
            return false;
        }
        Map<String, String> p1 = sURI.getParamsMap();
        Map<String, String> p2 = this.getParamsMap();
        if (p1 != null && p2 != null) {
            if (p1.size() != p2.size()) {
                return false;
            }
            for (String string : p1.keySet()) {
                if (p2.containsKey(string)) continue;
                return false;
            }
            for (Serializable serializable : p1.values()) {
                if (p2.containsValue(serializable)) continue;
                return false;
            }
        } else if (p1 != null || p2 != null) {
            return false;
        }
        return true;
    }

    @Override
    public int compareTo(ServerURI serverURI) {
        return serverURI.uri.compareTo(this.uri);
    }

    public static ServerURI create(String host, int port) {
        return new ServerURI(CSBASE_SCHEME + "://" + host + ":" + String.valueOf(port));
    }

    public static ServerURI parse(String uriStr) {
        try {
            ServerURI uri = new ServerURI(uriStr);
            if (uri.getHostAndPort() != null) {
                return new ServerURI(uriStr);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static boolean isValid(String uriStr) {
        return ServerURI.parse(uriStr) != null;
    }

    public static void main(String[] a) {
        ServerURI sUri1 = ServerURI.parse("csbase:/localhost?x=3");
        System.out.println(sUri1);
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("z", "");
        System.out.println(sUri1.appendParams(m));
    }
}

