/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.BasicColumn;
import csbase.logic.algorithms.parameters.validators.IntegerParameterValidator;
import csbase.logic.algorithms.parameters.validators.SimpleParameterValidator;
import tecgraf.javautils.core.lng.LNG;

public final class IntegerColumn
extends BasicColumn<Integer> {
    private Integer maximum;
    private Integer minimum;

    public IntegerColumn(String id, String label, Integer defaultValue, boolean isOptional, boolean isEditable, Integer maximum, Integer minimum) {
        super(id, label, defaultValue, isOptional, isEditable);
        this.setMaximum(maximum);
        this.setMinimum(minimum);
    }

    @Override
    public Integer getItemValueFromText(String itemValue) throws ParseException {
        if (itemValue == null) {
            return null;
        }
        try {
            int intValue = Integer.parseInt(itemValue);
            return new Integer(intValue);
        }
        catch (NumberFormatException e) {
            throw new ParseException(e, LNG.get((String)"csbase.logic.algorithms.parameters.InvalidInteger"), itemValue, this);
        }
    }

    public Integer getMaximum() {
        return this.maximum;
    }

    public Integer getMinimum() {
        return this.minimum;
    }

    private void setMaximum(Integer maximum) {
        if (this.minimum != null && maximum != null && maximum.compareTo(this.minimum) < 0) {
            throw new IllegalArgumentException(LNG.get((String)"csbase.logic.algorithms.parameters.MaxLessThanMin"));
        }
        this.maximum = maximum;
    }

    @Override
    public SimpleParameterValidator<Integer> getValidator() {
        return new IntegerParameterValidator(this.isOptional(), this.getMaximum(), this.getMinimum());
    }

    private void setMinimum(Integer minimum) {
        if (this.maximum != null && minimum != null && minimum.compareTo(this.maximum) > 0) {
            throw new IllegalArgumentException(LNG.get((String)"csbase.logic.algorithms.parameters.MinGreaterThenMax"));
        }
        this.minimum = minimum;
    }
}

