/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters.triggers;

import csbase.logic.algorithms.parameters.DoubleListParameter;
import csbase.logic.algorithms.parameters.DoubleParameter;
import csbase.logic.algorithms.parameters.SimpleParameter;
import csbase.logic.algorithms.parameters.conditions.Condition;
import csbase.logic.algorithms.parameters.triggers.Trigger;
import java.text.MessageFormat;
import tecgraf.javautils.core.lng.LNG;

public final class ChangeMaximumForDoublesTrigger
extends Trigger<SimpleParameter<?>> {
    private boolean isMaximumIncluded;
    private Double maximum;

    public ChangeMaximumForDoublesTrigger(DoubleParameter parameter, Condition condition, Double maximum, boolean isMaximumIncluded) {
        super(parameter, condition);
        this.isMaximumIncluded = isMaximumIncluded;
        this.maximum = maximum;
    }

    public ChangeMaximumForDoublesTrigger(DoubleListParameter parameter, Condition condition, Double maximum, boolean isMaximumIncluded) {
        super(parameter, condition);
        this.isMaximumIncluded = isMaximumIncluded;
        this.maximum = maximum;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        ChangeMaximumForDoublesTrigger trigger = (ChangeMaximumForDoublesTrigger)obj;
        if (this.isMaximumIncluded != trigger.isMaximumIncluded) {
            return false;
        }
        if (this.maximum == null && trigger.maximum == null) {
            return true;
        }
        return this.maximum != null && this.maximum.equals(trigger.maximum);
    }

    public Double getMaximum() {
        return this.maximum;
    }

    public boolean isMaximumIncluded() {
        return this.isMaximumIncluded;
    }

    @Override
    protected void doAction() {
        SimpleParameter parameter = (SimpleParameter)this.getParameter();
        if (parameter instanceof DoubleListParameter) {
            DoubleListParameter doubleListParameter = (DoubleListParameter)parameter;
            doubleListParameter.setMaximum(this.getMaximum(), this.isMaximumIncluded());
        } else if (parameter instanceof DoubleParameter) {
            DoubleParameter doubleParameter = (DoubleParameter)parameter;
            doubleParameter.setMaximum(this.getMaximum(), this.isMaximumIncluded());
        } else {
            throw new IllegalStateException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.parameters.InvalidType"), parameter.getLabel(), "real", "lista_de_reais"));
        }
    }

    @Override
    protected void undoAction() {
    }
}

