/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.applicationservice;

import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Properties;
import tecgraf.javautils.core.lng.LNG;

public class ApplicationCategory
implements Serializable {
    private static final String SHOWN_AT_APP_PANEL_PROPERTY = "shown.at.application.panel";
    private static final String SHOWN_AT_MENU_PROPERTY = "shown.at.application.menu";
    private final ArrayList<String> appIds = new ArrayList();
    private final String id;
    private final byte[] img16;
    private final byte[] img32;
    private final Properties properties;

    public ApplicationCategory(String id, Properties properties, byte[] img16, byte[] img32) {
        this.id = id;
        this.img16 = img16;
        this.img32 = img32;
        this.properties = properties;
    }

    public final String getCategoryName(Locale locale) {
        return this.getLocaledProperty("name", locale);
    }

    private String getLocaledProperty(String propertyName, Locale locale) {
        String language = locale.getLanguage();
        String country = locale.getCountry();
        Object[] args = new Object[]{language, country};
        String key = propertyName + ".{0}.{1}";
        String fmtKey = MessageFormat.format(key, args);
        String value = this.getStringSpecificProperty(fmtKey);
        return value;
    }

    public final String getStringSpecificProperty(String propName) {
        String tag = this.id + "." + propName;
        String value = this.properties.getProperty(tag);
        if (value == null || value.isEmpty()) {
            String err = String.format(LNG.get((String)"csbase.logic.applicationservice.UndefinedProperty"), propName, this.getId());
            throw new IllegalArgumentException(err);
        }
        return value.trim();
    }

    public final boolean getBooleanSpecificProperty(String propName) {
        String[] accepts;
        String str = this.getStringSpecificProperty(propName);
        for (String acc : accepts = new String[]{"true", "false"}) {
            if (!acc.equals(str.trim())) continue;
            boolean value = Boolean.parseBoolean(str);
            return value;
        }
        String err = String.format(LNG.get((String)"csbase.logic.applicationservice.BadBooleanFormat"), propName, this.getId());
        throw new IllegalArgumentException(err);
    }

    public final String getId() {
        return this.id;
    }

    public final String toString() {
        return this.getId();
    }

    public final boolean isShownAtApplicationMenu() {
        return this.getBooleanSpecificProperty(SHOWN_AT_MENU_PROPERTY);
    }

    public final boolean isShownAtApplicationPanel() {
        return this.getBooleanSpecificProperty(SHOWN_AT_APP_PANEL_PROPERTY);
    }

    public final ArrayList<String> getApplicationIds() {
        return this.appIds;
    }

    public final void addApplicationId(String appId) {
        this.appIds.add(appId);
    }

    public final byte[] getIcon() {
        return this.img16;
    }

    public final byte[] getImage() {
        return this.img32;
    }
}

