/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.ListParameter;
import csbase.logic.algorithms.parameters.validators.TextParameterValidator;
import java.util.Collection;
import java.util.List;
import tecgraf.javautils.core.lng.LNG;

public final class TextListParameter
extends ListParameter<String> {
    public static final String TYPE = "LIST_OF_TEXTS";
    private Integer maxCharacters;

    public TextListParameter(String name, String label, String description, List<String> defaultValue, boolean isOptional, boolean isVisible, String commandLinePattern, Integer maxCharacters) {
        super(name, label, description, defaultValue, isOptional, isVisible, false, true, commandLinePattern);
        this.setMaxCharacters(maxCharacters);
    }

    @Override
    public String getItemValueFromText(String itemValue) {
        return itemValue;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public Integer getMaxCharacters() {
        return this.maxCharacters;
    }

    private void setMaxCharacters(Integer maxCharacters) {
        if (maxCharacters != null && maxCharacters <= 0) {
            throw new IllegalArgumentException(String.format(LNG.get((String)"csbase.logic.algorithms.positiveParameter"), "maxCharacters", maxCharacters.toString()));
        }
        this.maxCharacters = maxCharacters;
    }

    protected TextParameterValidator createItemValidator() {
        return new TextParameterValidator(this.isOptional(), this.maxCharacters);
    }

    @Override
    public void setJSONValue(Object value) {
        Collection list = (Collection)List.class.cast(value);
        list.forEach(i -> this.addElement((String)i));
    }
}

