/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.ParameterDocumentation;
import csbase.logic.algorithms.parameters.ParameterRegistry;
import csbase.logic.algorithms.parsers.BooleanParameterFactory;
import csbase.logic.algorithms.parsers.ClientSGAFileParameterFactory;
import csbase.logic.algorithms.parsers.DefaultTableParameterFactory;
import csbase.logic.algorithms.parsers.DoubleListParameterFactory;
import csbase.logic.algorithms.parsers.DoubleParameterFactory;
import csbase.logic.algorithms.parsers.EnumerationParameterFactory;
import csbase.logic.algorithms.parsers.FormulaParameterFactory;
import csbase.logic.algorithms.parsers.InputFileParameterFactory;
import csbase.logic.algorithms.parsers.InputURLParameterFactory;
import csbase.logic.algorithms.parsers.IntegerListParameterFactory;
import csbase.logic.algorithms.parsers.IntegerParameterFactory;
import csbase.logic.algorithms.parsers.OutputFileParameterFactory;
import csbase.logic.algorithms.parsers.OutputURLParameterFactory;
import csbase.logic.algorithms.parsers.ParameterFactory;
import csbase.logic.algorithms.parsers.TextListParameterFactory;
import csbase.logic.algorithms.parsers.TextParameterFactory;
import csbase.logic.algorithms.parsers.elements.IElementStructure;
import csbase.logic.algorithms.parsers.elements.attributes.IElementAttribute;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;

public class DefaultParameterRegistry
implements ParameterRegistry {
    private final Map<String, ParameterFactory> parameterFactoryMap = new HashMap<String, ParameterFactory>();

    public DefaultParameterRegistry() {
        this.parameterFactoryMap.put("arquivo_de_saida", new OutputFileParameterFactory());
        this.parameterFactoryMap.put("arquivo_de_entrada", new InputFileParameterFactory());
        this.parameterFactoryMap.put("booleano", new BooleanParameterFactory());
        this.parameterFactoryMap.put("enumeracao", new EnumerationParameterFactory());
        this.parameterFactoryMap.put("formula", new FormulaParameterFactory());
        this.parameterFactoryMap.put("inteiro", new IntegerParameterFactory());
        this.parameterFactoryMap.put("lista_de_inteiros", new IntegerListParameterFactory());
        this.parameterFactoryMap.put("lista_de_reais", new DoubleListParameterFactory());
        this.parameterFactoryMap.put("lista_de_texto", new TextListParameterFactory());
        this.parameterFactoryMap.put("real", new DoubleParameterFactory());
        this.parameterFactoryMap.put("tabela", new DefaultTableParameterFactory());
        this.parameterFactoryMap.put("texto", new TextParameterFactory());
        this.parameterFactoryMap.put("arquivo_sga", new ClientSGAFileParameterFactory());
        this.parameterFactoryMap.put("url_de_entrada", new InputURLParameterFactory());
        this.parameterFactoryMap.put("url_de_saida", new OutputURLParameterFactory());
    }

    @Override
    public Map<String, ParameterFactory> getParameterFactories() {
        return this.parameterFactoryMap;
    }

    @Override
    public ParameterDocumentation getParameterDocumentation(IElementStructure<?> structure, Locale locale) {
        Class<?> parameterClass = structure.getElementClass();
        String file = parameterClass.getSimpleName() + "_" + locale + ".properties";
        InputStream inStream = parameterClass.getResourceAsStream(file);
        Properties prop = new Properties();
        ParameterDocumentation documentation = new ParameterDocumentation();
        if (inStream != null) {
            try {
                prop.load(inStream);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            String title = prop.getProperty("title");
            documentation.setTitle(title);
            String description = prop.getProperty("description");
            documentation.setDescription(description);
            Iterator<IElementAttribute<?>> iterator = structure.getAttributes().iterator();
            while (iterator.hasNext()) {
                IElementAttribute<?> attributeObj;
                IElementAttribute<?> attribute = attributeObj = iterator.next();
                String name = attribute.getName();
                String attrDoc = prop.getProperty(name);
                documentation.addAttribute(name, attrDoc);
            }
        }
        return documentation;
    }
}

