/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import csbase.exception.ParseException;
import csbase.logic.algorithms.CommandLineContext;
import csbase.logic.algorithms.CommandLineParameterFormatter;
import csbase.logic.algorithms.parameters.Parameter;
import csbase.logic.algorithms.parameters.SimpleParameterListener;
import csbase.logic.algorithms.parameters.validators.SimpleParameterValidator;
import csbase.logic.algorithms.validation.Validation;
import csbase.logic.algorithms.validation.ValidationContext;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import tecgraf.javautils.core.lng.LNG;

public abstract class SimpleParameter<V>
extends Parameter<V> {
    private String commandLinePattern;
    private V defaultValue;
    private String description;
    private boolean isEnabled;
    private boolean isOptional;
    private boolean isVisible;
    private String label;
    private List<SimpleParameterListener<V>> listeners = new LinkedList<SimpleParameterListener<V>>();
    private V value;
    private boolean ignoreIfInvisible;
    private boolean ignoreIfDisabled;
    private SimpleParameterValidator<V> parameterValidator;

    protected SimpleParameter(String name, String label, String description, V defaultValue, boolean isOptional, boolean isVisible, String commandLinePattern) {
        super(name);
        this.defaultValue = defaultValue;
        this.isOptional = isOptional;
        this.commandLinePattern = commandLinePattern;
        this.ignoreIfDisabled = false;
        this.ignoreIfInvisible = false;
        this.setEnabled(true);
        this.setVisible(isVisible);
        this.setValue(this.getDefaultValue());
        this.setLabel(label);
        this.setDescription(description);
    }

    public final void addSimpleParameterListener(SimpleParameterListener<V> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "listener"));
        }
        this.listeners.add(listener);
    }

    @Override
    public Map<String, Object> exportValue() {
        HashMap<String, V> parameterValue = new HashMap<String, V>();
        parameterValue.put(this.getName(), this.getValue());
        return Collections.unmodifiableMap(parameterValue);
    }

    @Override
    public final String getCommandLine(CommandLineContext context) {
        if (this.commandLinePattern == null) {
            return null;
        }
        if (!this.isVisible && this.ignoreIfInvisible) {
            return null;
        }
        if (!this.isEnabled && this.ignoreIfDisabled) {
            return null;
        }
        String commandValue = this.getCommandValue(context);
        return CommandLineParameterFormatter.formatCommandLine(this.getName(), commandValue, this.getCommandLinePattern());
    }

    public String getCommandLinePattern() {
        return this.commandLinePattern;
    }

    public V getDefaultValue() {
        return this.defaultValue;
    }

    public final String getDescription() {
        return this.description;
    }

    public abstract Object getExpressionValue();

    public final String getLabel() {
        return this.label;
    }

    public final List<SimpleParameterListener<V>> getSimpleParameterListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public abstract String getType();

    public final V getValue() {
        return this.value;
    }

    public String getValueAsText() {
        if (this.getValue() == null) {
            return null;
        }
        return this.getValue().toString();
    }

    @Override
    public void importValue(Map<String, Object> parameterValues) {
        if (parameterValues == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "parameterValues"));
        }
        this.setValue(parameterValues.get(this.getName()));
    }

    public final boolean isEnabled() {
        return this.isEnabled;
    }

    public final boolean isOptional() {
        return this.isOptional;
    }

    @Override
    public boolean isSetDefaultValue() {
        V val = this.getValue();
        V defaultVal = this.getDefaultValue();
        if (val == null) {
            return defaultVal == null;
        }
        return val.equals(defaultVal);
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    public final boolean removeSimpleParameterListener(SimpleParameterListener<V> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener == null");
        }
        return this.listeners.remove(listener);
    }

    @Override
    public void resetValue() {
        this.setValue(this.getDefaultValue());
    }

    public final boolean setDefaultValue(V defaultValue) {
        if (this.defaultValue == null && defaultValue == null) {
            return false;
        }
        if (this.defaultValue != null && this.defaultValue.equals(defaultValue)) {
            return false;
        }
        this.defaultValue = defaultValue;
        this.fireDefaultValueWasChangedEvent();
        return true;
    }

    public final boolean setEnabled(boolean isEnabled) {
        if (this.isEnabled == isEnabled) {
            return false;
        }
        this.isEnabled = isEnabled;
        this.fireCapabilityWasChangedEvent();
        return true;
    }

    public final boolean setLabel(String label) {
        if (label == null) {
            throw new IllegalArgumentException("label == null");
        }
        if (label.equals(this.label)) {
            return false;
        }
        this.label = label;
        this.fireLabelWasChangedEvent();
        return true;
    }

    public boolean setValue(V value) {
        if (this.value == null && value == null) {
            return false;
        }
        if (this.value != null && this.value.equals(value)) {
            return false;
        }
        this.value = value;
        this.fireValueWasChangedEvent();
        return true;
    }

    public abstract void setValueAsText(String var1) throws ParseException;

    @Override
    public final boolean setVisible(boolean isVisible) {
        if (this.isVisible == isVisible) {
            return false;
        }
        this.isVisible = isVisible;
        this.fireVisiblityWasChangedEvent();
        return true;
    }

    protected void fireValueWasChangedEvent() {
        for (SimpleParameterListener<V> listener : this.listeners) {
            listener.valueWasChanged(this);
        }
    }

    protected final void fireVisiblityWasChangedEvent() {
        for (SimpleParameterListener<V> listener : this.listeners) {
            listener.visibilityWasChanged(this);
        }
    }

    protected String getCommandValue(CommandLineContext context) {
        V val = this.getValue();
        if (val == null) {
            return null;
        }
        return val.toString();
    }

    private void fireCapabilityWasChangedEvent() {
        for (SimpleParameterListener<V> listener : this.listeners) {
            listener.capabilityWasChanged(this);
        }
    }

    private void fireDefaultValueWasChangedEvent() {
        for (SimpleParameterListener<V> listener : this.listeners) {
            listener.defaultValueWasChanged(this);
        }
    }

    private void fireLabelWasChangedEvent() {
        for (SimpleParameterListener<V> listener : this.listeners) {
            listener.labelWasChanged(this);
        }
    }

    private void setDescription(String description) {
        if (description == null) {
            throw new IllegalArgumentException("description == null");
        }
        this.description = description;
    }

    public boolean ignoreIfInvisible() {
        return this.ignoreIfInvisible;
    }

    public void setIgnoreIfInvisible(boolean ignoreIfInvisible) {
        this.ignoreIfInvisible = ignoreIfInvisible;
    }

    public boolean ignoreIfDisabled() {
        return this.ignoreIfDisabled;
    }

    public void setIgnoreIfDisabled(boolean ignoreIfDisabled) {
        this.ignoreIfDisabled = ignoreIfDisabled;
    }

    @Override
    public final Validation validate(ValidationContext context) throws RemoteException {
        SimpleParameterValidator<V> validator = this.getParameterValidator();
        validator.setMode(context.getMode());
        Validation result = validator.validateValue(this, this.getValue(), context);
        return result;
    }

    public SimpleParameterValidator<V> getParameterValidator() {
        if (this.parameterValidator == null) {
            this.parameterValidator = this.createParameterValidator();
        }
        return this.parameterValidator;
    }

    public abstract SimpleParameterValidator<V> createParameterValidator();

    public String getValueAsJSON() {
        return this.objectToJSON(this.getValue());
    }

    protected String objectToJSON(Object value) {
        if (value != null && !value.toString().isEmpty()) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                return objectMapper.writeValueAsString(value);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public abstract void setJSONValue(Object var1) throws ParseException;
}

