/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.logic.ProjectFileTypeFilter;
import csbase.logic.ProjectFileTypeInfo;
import csbase.remote.ClientRemoteLocator;
import csbase.util.StringUtils;
import csbase.util.restart.RestartListener;
import csbase.util.restart.RestartManager;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class ProjectFileType
implements Serializable,
Comparable<ProjectFileType> {
    public static final String DIRECTORY_TYPE = "DIRECTORY_TYPE";
    public static final String UNKNOWN = "UNKNOWN";
    private static Map<String, ProjectFileType> fileTypes;
    protected static ProjectFileType projectFileTypePrototype;
    private String description;
    private List<String> extensions;
    private String mimeType;
    private String typeCode;
    private boolean isDirectory;

    @Override
    public int compareTo(ProjectFileType fileType) {
        if (this.description == null) {
            return -1;
        }
        if (fileType == null) {
            return -1;
        }
        String desc = fileType.getDescription();
        if (desc == null) {
            return -1;
        }
        return StringUtils.compare((String)this.description, (String)desc);
    }

    protected ProjectFileType createProjectFileType(ProjectFileTypeInfo info) {
        return new ProjectFileType(info);
    }

    public String getCode() {
        return this.typeCode;
    }

    public String getDescription() {
        return this.description;
    }

    public List<String> getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public boolean isDirectory() {
        return this.isDirectory;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProjectFileType other = (ProjectFileType)obj;
        return this.typeCode.equals(other.typeCode);
    }

    public int hashCode() {
        return this.typeCode.hashCode();
    }

    public String toString() {
        return this.description;
    }

    protected ProjectFileType() {
    }

    public ProjectFileType(ProjectFileTypeInfo info) {
        this.typeCode = info.getCode();
        this.description = info.getDescription();
        this.mimeType = info.getMimeType();
        this.extensions = new ArrayList<String>();
        this.extensions.addAll(info.getExtensions());
        this.isDirectory = info.isDirectory();
    }

    public static SortedSet<ProjectFileType> getFileTypes(ProjectFileTypeFilter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("O par\u00e2metro filter \u00e9 null.");
        }
        TreeSet<ProjectFileType> types = new TreeSet<ProjectFileType>();
        for (ProjectFileType type : fileTypes.values()) {
            if (!filter.accept(type)) continue;
            types.add(type);
        }
        return Collections.unmodifiableSortedSet(types);
    }

    public static ProjectFileType getUnknownFileType() {
        return fileTypes.get(UNKNOWN);
    }

    public static ProjectFileType getFileType(String typeCode) {
        ProjectFileType type = null;
        if (fileTypes == null) {
            ProjectFileTypeInfo info;
            try {
                info = ClientRemoteLocator.projectService.getFileType(typeCode);
            }
            catch (Exception e) {
                return null;
            }
            type = info != null ? projectFileTypePrototype.createProjectFileType(info) : null;
        } else {
            type = fileTypes.get(typeCode);
            if (type == null) {
                type = fileTypes.get(UNKNOWN);
            }
        }
        return type;
    }

    public static ProjectFileType getProjectFileTypeFromExtension(String extension, boolean isDirectory) {
        String unknownTypeCode = isDirectory ? DIRECTORY_TYPE : UNKNOWN;
        ProjectFileType unknownType = ProjectFileType.getFileType(unknownTypeCode);
        if (extension == null) {
            return unknownType;
        }
        for (ProjectFileType pft : fileTypes.values()) {
            if (pft.isDirectory() != isDirectory) continue;
            List<String> exts = pft.getExtensions();
            for (String ext : exts) {
                if (!extension.equalsIgnoreCase(ext)) continue;
                return pft;
            }
        }
        return unknownType;
    }

    public static void loadFileTypes(Locale locale) throws RemoteException {
        if (fileTypes != null) {
            return;
        }
        fileTypes = new HashMap<String, ProjectFileType>();
        Map<String, ProjectFileTypeInfo> fileTypesInfo = ClientRemoteLocator.projectService.getAllFileTypes(locale);
        for (ProjectFileTypeInfo info : fileTypesInfo.values()) {
            ProjectFileType pft = projectFileTypePrototype.createProjectFileType(info);
            fileTypes.put(info.getCode(), pft);
        }
    }

    static {
        RestartManager.getInstance().addListener(new RestartListener(){

            public void restart() {
                fileTypes = null;
            }
        });
        projectFileTypePrototype = new ProjectFileType();
    }
}

