/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic;

import csbase.exception.administration.AdministrationDeleteException;
import csbase.logic.AdministrationEvent;
import csbase.logic.Getter;
import csbase.logic.IdInterface;
import csbase.logic.User;
import csbase.logic.UserGroupInfo;
import csbase.remote.ClientRemoteLocator;
import csbase.util.restart.RestartListener;
import csbase.util.restart.RestartManager;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import tecgraf.javautils.core.lng.LNG;

public class UserGroup
implements Serializable,
IdInterface {
    public static final String USERGROUP_ID = "unId";
    private static Hashtable<Object, UserGroup> userGroups = new Hashtable();
    private static boolean hasAllUserGroups = false;
    private final Object id;
    private final UserGroupInfo info;
    private static Observable observable = new Observable(){

        @Override
        public void notifyObservers(Object arg) {
            this.setChanged();
            super.notifyObservers(arg);
        }
    };

    public UserGroup(Object id, UserGroupInfo info) {
        this.id = id;
        this.info = info;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof UserGroup)) {
            return false;
        }
        UserGroup userGroup = (UserGroup)obj;
        return userGroup.getId().equals(this.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public boolean equalContents(Object obj) {
        if (!(obj instanceof UserGroup)) {
            return false;
        }
        UserGroup userGroup = (UserGroup)obj;
        return userGroup.getId().equals(this.id) && userGroup.getUserGroupInfo().equals(this.info);
    }

    public static UserGroup getUserGroup(Object id) throws RemoteException {
        if (id == null) {
            return null;
        }
        UserGroup userGroup = userGroups.get(id);
        if (userGroup == null && !hasAllUserGroups && (userGroup = ClientRemoteLocator.administrationService.getUserGroup(id)) != null) {
            userGroups.put(id, userGroup);
        }
        return userGroup;
    }

    public static UserGroup getUserGroupByName(String name) throws RemoteException {
        List<UserGroup> allUserGroups = UserGroup.getAllUserGroups();
        for (UserGroup userGroup : allUserGroups) {
            if (!userGroup.getName().equalsIgnoreCase(name)) continue;
            return userGroup;
        }
        return null;
    }

    public static UserGroup getUserGroupFromUser(User user) throws RemoteException {
        Object userGroupId = user.getAttribute(USERGROUP_ID);
        if (userGroupId == null) {
            return null;
        }
        UserGroup userGroup = UserGroup.getUserGroup(userGroupId);
        return userGroup;
    }

    public static List<UserGroup> getAllUserGroups() throws RemoteException {
        if (hasAllUserGroups) {
            return UserGroup.userGroupsToVector();
        }
        List<UserGroup> allUserGroups = ClientRemoteLocator.administrationService.getAllUserGroups();
        for (UserGroup userGroup : allUserGroups) {
            if (userGroups.containsKey(userGroup.getId())) continue;
            userGroups.put(userGroup.getId(), userGroup);
        }
        if (allUserGroups.size() > 0) {
            hasAllUserGroups = true;
        }
        return allUserGroups;
    }

    public static UserGroup createUserGroup(UserGroupInfo info) throws Exception {
        if (info.name == null || info.name.trim().equals("")) {
            throw new Exception(LNG.get((String)"csbase.logic.EmptyName"));
        }
        if (UserGroup.getUserGroupByName(info.name) != null) {
            return null;
        }
        UserGroup userGroup = ClientRemoteLocator.administrationService.createUserGroup(info);
        if (userGroup != null) {
            userGroups.put(userGroup.getId(), userGroup);
        }
        return userGroup;
    }

    public static UserGroup modifyUserGroup(Object id, UserGroupInfo info) throws RemoteException {
        UserGroup userGroup = UserGroup.getUserGroup(id);
        if (userGroup == null) {
            return null;
        }
        if (!userGroup.getName().equals(info.name) && UserGroup.existsAnotherUserGroup(id, info.name)) {
            return null;
        }
        userGroup = ClientRemoteLocator.administrationService.modifyUserGroup(id, info);
        userGroups.put(id, userGroup);
        return userGroup;
    }

    public static boolean existsAnotherUserGroup(Object id, String name) throws RemoteException {
        UserGroup anotherUserGroup = UserGroup.getUserGroupByName(name);
        return anotherUserGroup != null && !anotherUserGroup.getId().equals(id);
    }

    public static void deleteUserGroup(Object id) throws RemoteException, AdministrationDeleteException {
        ClientRemoteLocator.administrationService.deleteUserGroup(id);
        userGroups.remove(id);
    }

    private static Vector<UserGroup> userGroupsToVector() {
        Vector<UserGroup> allUserGroups = new Vector<UserGroup>();
        Enumeration<UserGroup> e = userGroups.elements();
        while (e.hasMoreElements()) {
            allUserGroups.add(e.nextElement());
        }
        return allUserGroups;
    }

    public static Comparator<UserGroup> getNameComparator() {
        Comparator<UserGroup> userGroupComparator = new Comparator<UserGroup>(){

            @Override
            public int compare(UserGroup ug1, UserGroup ug2) {
                return ug1.getName().compareTo(ug2.getName());
            }
        };
        return userGroupComparator;
    }

    public static Comparator<UserGroup> getDescComparator() {
        Comparator<UserGroup> userGroupComparator = new Comparator<UserGroup>(){

            @Override
            public int compare(UserGroup ug1, UserGroup ug2) {
                return ug1.getDesc().compareTo(ug2.getDesc());
            }
        };
        return userGroupComparator;
    }

    public static Getter getNameGetter() {
        Getter nameGetter = new Getter(){

            @Override
            public Object get(Object o) {
                UserGroup userGroup = (UserGroup)o;
                return userGroup.getName();
            }
        };
        return nameGetter;
    }

    public static Getter getIdGetter() {
        Getter idGetter = new Getter(){

            @Override
            public Object get(Object o) {
                UserGroup userGroup = (UserGroup)o;
                return userGroup.getId();
            }
        };
        return idGetter;
    }

    public static Getter getDescGetter() {
        Getter infoGetter = new Getter(){

            @Override
            public Object get(Object o) {
                UserGroup userGroup = (UserGroup)o;
                return userGroup.getDesc();
            }
        };
        return infoGetter;
    }

    public static void addObserver(Observer o) {
        observable.addObserver(o);
    }

    public static void deleteObserver(Observer o) {
        observable.deleteObserver(o);
    }

    public static void update(AdministrationEvent event) {
        UserGroup userGroup = (UserGroup)event.item;
        Object id = userGroup.getId();
        switch (event.type) {
            case 1: 
            case 2: {
                userGroups.put(id, userGroup);
                break;
            }
            case 3: {
                userGroups.remove(id);
            }
        }
        observable.notifyObservers(event);
    }

    @Override
    public Object getId() {
        return this.id;
    }

    public String getName() {
        return this.info.name;
    }

    public String getDesc() {
        return this.info.desc;
    }

    public UserGroupInfo getInfo() {
        return this.info;
    }

    public UserGroupInfo getUserGroupInfo() {
        return (UserGroupInfo)this.info.clone();
    }

    public void setName(String name) {
        this.info.name = name;
    }

    public void setDesc(String desc) {
        this.info.desc = desc;
    }

    public String toString() {
        String userGroupString = "";
        userGroupString = userGroupString + this.info.name;
        userGroupString = userGroupString + "\t";
        userGroupString = userGroupString + this.info.desc;
        return userGroupString;
    }

    static {
        RestartManager.getInstance().addListener(new RestartListener(){

            public void restart() {
                userGroups = new Hashtable();
                hasAllUserGroups = false;
                observable.deleteObservers();
            }
        });
    }
}

