/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms;

import java.io.Serializable;
import java.text.MessageFormat;
import tecgraf.javautils.core.lng.LNG;

public class AlgorithmProperty
implements Serializable {
    public static final String TYPE_SUFFIX = ".tipo";
    private String key;
    private String label;
    private PropertyType type;

    public AlgorithmProperty(String key, String label, PropertyType type) {
        this.key = key;
        this.label = label;
        this.type = type;
    }

    public AlgorithmProperty(String key, String label) {
        this(key, label, PropertyType.STRING);
    }

    public String getKey() {
        return this.key;
    }

    public String getLabel() {
        return this.label;
    }

    public PropertyType getType() {
        return this.type;
    }

    public boolean isValidValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException(MessageFormat.format(LNG.get((String)"csbase.logic.algorithms.nullParameter"), "value"));
        }
        if (value.length() == 0) {
            return true;
        }
        switch (this.type) {
            case STRING: {
                return true;
            }
            case DOUBLE: {
                try {
                    Double.parseDouble(value);
                    return true;
                }
                catch (NumberFormatException exception) {
                    return false;
                }
            }
        }
        return true;
    }

    public static enum PropertyType {
        STRING,
        DOUBLE;

    }
}

