/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parameters;

import csbase.logic.algorithms.parameters.FileParameterListener;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.SimpleParameter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class AbstractFileParameter
extends SimpleParameter<FileURLValue> {
    public static final String PATH = ".path";
    public static final String TYPE = ".type";
    protected FileParameterPipeAcceptance usesPipe;
    protected String[] fileTypes;
    protected boolean hasLink = false;
    protected transient List<FileParameterListener> listeners = new LinkedList<FileParameterListener>();
    protected FileParameterMode mode;
    protected final boolean mustExist;

    protected AbstractFileParameter(String name, String label, String description, FileURLValue defaultValue, boolean isOptional, boolean isVisible, String commandLinePattern, String[] fileTypes, FileParameterMode mode, FileParameterPipeAcceptance usesPipe, boolean mustExist) {
        super(name, label, description, defaultValue, isOptional, isVisible, commandLinePattern);
        this.mustExist = mustExist;
        this.setUsesPipe(usesPipe);
        this.setFileTypes(fileTypes);
        this.setMode(mode);
    }

    public final FileParameterPipeAcceptance usesPipe() {
        return this.usesPipe;
    }

    public final void addParameterListener(FileParameterListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        this.listeners.add(listener);
    }

    @Override
    public final Object getExpressionValue() {
        return null;
    }

    public final List<FileParameterListener> getFileParameterListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public final String[] getFileTypes() {
        return this.fileTypes;
    }

    public final FileParameterMode getMode() {
        return this.mode;
    }

    public final boolean hasLink() {
        return this.hasLink;
    }

    public final boolean removeFileParameterListener(FileParameterListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("O par\u00e2metro listener est\u00e1 nulo.");
        }
        return this.listeners.add(listener);
    }

    public final void setFileTypes(String[] fileTypes) {
        if (fileTypes == null) {
            this.fileTypes = new String[0];
        } else {
            if (fileTypes.length > 1 && this.usesPipe != FileParameterPipeAcceptance.FALSE) {
                throw new IllegalArgumentException("O par\u00e2metro n\u00e3o pode ter mais de um tipo de arquivo associado se aceitar pipes.");
            }
            this.fileTypes = fileTypes;
        }
        for (FileParameterListener listener : this.listeners) {
            listener.typeWasChanged(this);
        }
        this.fireVisiblityWasChangedEvent();
    }

    public final void setHasLink(boolean hasLink) {
        this.hasLink = hasLink;
        for (FileParameterListener listener : this.listeners) {
            listener.hasLinkWasChanged(this);
        }
        this.fireVisiblityWasChangedEvent();
    }

    protected void setMode(FileParameterMode mode) {
        if (mode == null) {
            throw new IllegalArgumentException("O par\u00e2metro mode est\u00e1 nulo.");
        }
        this.mode = mode;
    }

    protected void setUsesPipe(FileParameterPipeAcceptance usesPipe) {
        if (usesPipe == null) {
            throw new IllegalArgumentException("O par\u00e2metro usesPipe est\u00e1 nulo.");
        }
        if (this.fileTypes != null && this.fileTypes.length > 1 && usesPipe != FileParameterPipeAcceptance.FALSE) {
            throw new IllegalArgumentException("O par\u00e2metro n\u00e3o pode aceitar pipe se tiver mais de um tipo de arquivo associado.");
        }
        this.usesPipe = usesPipe;
    }

    public boolean mustExist() {
        return this.mustExist;
    }

    public abstract boolean isOuput();
}

