/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms.parsers;

import csbase.exception.ParseException;
import csbase.logic.algorithms.parameters.FileParameterMode;
import csbase.logic.algorithms.parameters.FileParameterPipeAcceptance;
import csbase.logic.algorithms.parameters.FileURLValue;
import csbase.logic.algorithms.parameters.InputFileListParameter;
import csbase.logic.algorithms.parsers.AbstractFileParameterParser;
import csbase.logic.algorithms.parsers.elements.ParameterStructure;
import csbase.logic.algorithms.parsers.elements.ParsedSimpleParameter;
import csbase.logic.algorithms.parsers.elements.attributes.BooleanAttribute;
import csbase.logic.algorithms.parsers.elements.attributes.FileElementPipeAcceptanceAttribute;
import java.util.ArrayList;
import tecgraf.javautils.core.lng.LNG;

class InputFileListParameterParser
extends AbstractFileParameterParser<InputFileListParameter> {
    InputFileListParameterParser() {
    }

    @Override
    public InputFileListParameter createFileParameter(ParsedSimpleParameter definition, String[] types, FileParameterMode mode) throws ParseException {
        FileParameterPipeAcceptance usesPipe = (FileParameterPipeAcceptance)((Object)definition.getAttributeValue("permitir_pipe"));
        if (usesPipe == FileParameterPipeAcceptance.TRUE || usesPipe == FileParameterPipeAcceptance.ALWAYS) {
            throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.NoPipesInputFile"));
        }
        boolean useRootDirectoryAsDefault = (Boolean)definition.getAttributeValue("usar_diretorio_raiz_como_padrao");
        ArrayList<FileURLValue> defaultValue = null;
        if (useRootDirectoryAsDefault) {
            if (mode == FileParameterMode.REGULAR_FILE) {
                throw new ParseException(LNG.get((String)"csbase.logic.algorithms.parsers.InputFileInvalidAttribute", (Object[])new Object[]{"usar_diretorio_raiz_como_padrao"}));
            }
            defaultValue = new ArrayList<FileURLValue>();
            defaultValue.add(new FileURLValue(".", "DIRECTORY_TYPE"));
        }
        boolean mustSort = (Boolean)definition.getAttributeValue("ordenar");
        boolean useFilter = (Boolean)definition.getAttributeValue("usar_filtro");
        InputFileListParameter parameter = new InputFileListParameter(definition.getName(), definition.getLabel(), definition.getDescription(), defaultValue, definition.isOptional(), definition.isVisible(), definition.getCommandLinePattern(), types, mode, mustSort, useFilter);
        return parameter;
    }

    @Override
    public ParameterStructure<InputFileListParameter> getParameterStructure() {
        ParameterStructure<InputFileListParameter> fileStructure = this.getFileStructure("arquivo_de_entrada", InputFileListParameter.class);
        fileStructure.addAttribute(new FileElementPipeAcceptanceAttribute("permitir_pipe", FileParameterPipeAcceptance.FALSE));
        fileStructure.addAttribute(new BooleanAttribute("usar_diretorio_raiz_como_padrao", false));
        fileStructure.addAttribute(new BooleanAttribute("ordenar", true));
        fileStructure.addAttribute(new BooleanAttribute("usar_filtro", false));
        return fileStructure;
    }

    @Override
    protected boolean acceptBothCategory() {
        return true;
    }
}

