/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.diskusageservice;

import java.io.Serializable;

public class DiskOccupation
implements Serializable {
    private final long free;
    private final long total;
    public final long alertLimit;
    public final long warningLimit;

    private final double bytesToMb(long bytes) {
        return bytes / 0x100000L;
    }

    public final double getFreeSpaceMb() {
        return this.bytesToMb(this.free);
    }

    public final double getTotalSpaceMb() {
        return this.bytesToMb(this.total);
    }

    public final double getUsedSpaceMb() {
        long used = this.total - this.free;
        return this.bytesToMb(used);
    }

    public final double getFreeSpacePerc() {
        double totalSpaceMb = this.getTotalSpaceMb();
        if (totalSpaceMb <= 0.0) {
            return 0.0;
        }
        double freeSpaceMb = this.getFreeSpaceMb();
        return freeSpaceMb / totalSpaceMb * 100.0;
    }

    public final double getUsedSpacePerc() {
        double totalSpaceMb = this.getTotalSpaceMb();
        if (totalSpaceMb <= 0.0) {
            return 100.0;
        }
        double usedSpaceMb = this.getUsedSpaceMb();
        return usedSpaceMb / totalSpaceMb * 100.0;
    }

    public DiskOccupation(long free, long total, long alertLimit, long warningLimit) {
        this.free = free;
        this.total = total;
        this.alertLimit = alertLimit;
        this.warningLimit = warningLimit;
    }

    public DiskOccupation() {
        this.free = -1L;
        this.total = -1L;
        this.alertLimit = -1L;
        this.warningLimit = -1L;
    }

    public boolean isValid() {
        return this.free >= 0L && this.total >= 0L;
    }
}

