/*
 * Decompiled with CFR 0.152.
 */
package csbase.logic.algorithms;

import csbase.logic.algorithms.CommandLineContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FlowCommandLineContext
extends CommandLineContext {
    private Map<Integer, CommandLineContext> flowNodeContexts;
    private Map<Integer, Map<String, String>> fromPipes;
    private Map<Integer, Map<String, String>> toPipes;
    private Map<Integer, Map<String, String>> linkDirectories;

    protected FlowCommandLineContext(CommandLineContext context, Map<Integer, Map<String, String>> fromPipes, Map<Integer, Map<String, String>> toPipes, Map<Integer, Map<String, String>> linkDirectories) {
        super(context);
        this.fromPipes = fromPipes == null ? Collections.emptyMap() : fromPipes;
        this.toPipes = toPipes == null ? Collections.emptyMap() : toPipes;
        this.linkDirectories = linkDirectories == null ? Collections.emptyMap() : linkDirectories;
        this.flowNodeContexts = new HashMap<Integer, CommandLineContext>();
    }

    public void addFlowNodeContext(Integer nodeId, CommandLineContext flowNodeContext) {
        this.flowNodeContexts.put(nodeId, flowNodeContext);
    }

    public CommandLineContext getFlowNodeContext(Integer nodeId) {
        return this.flowNodeContexts.get(nodeId);
    }

    public void clearFlowNodeContexts() {
        this.flowNodeContexts.clear();
    }

    public Map<Integer, Map<String, String>> getFromPipes() {
        return this.fromPipes;
    }

    public Map<Integer, Map<String, String>> getToPipes() {
        return this.toPipes;
    }

    public Map<Integer, Map<String, String>> getLinkDirectories() {
        return this.linkDirectories;
    }

    public static FlowCommandLineContext createFlowContext(CommandLineContext context, Map<Integer, Map<String, String>> fromPipes, Map<Integer, Map<String, String>> toPipes, Map<Integer, Map<String, String>> linkDirectories) {
        return new FlowCommandLineContext(context, fromPipes, toPipes, linkDirectories);
    }
}

